% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_cata_format2.R
\name{change_cata_format2}
\alias{change_cata_format2}
\title{Change format of CATA datasets to perform the package functions}
\usage{
change_cata_format2(Data, nprod, nattr, nsub, nsess)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to your data}

\item{nprod}{integer. Number of products}

\item{nattr}{integer. Number of attributes}

\item{nsub}{integer. Number of subjects.}

\item{nsess}{integer. Number of sessions}
}
\value{
The arranged data for CATATIS and CLUSCATA function and the subjects names in the correct order.
}
\description{
CATATIS and CLUSCATA operate on data where the blocks of variables are merged horizontally.
If you have a vertical format, you can use this function to change the format.
The first column must contain the sessions, the second the subjects, the third the products and the others the attributes. If you don't have sessions, then the first column must contain the subjects and the second the products.
Unlike change_cata_format function, you can enter data with sessions and/or mixed data in terms of products/subjects. However, you have to set columns to indicate this beforehand.
}
\examples{

#Vertical format with sessions
data("PB_tuna")
chang=change_cata_format2(PB_tuna, nprod= 6, nattr= 27, nsub = 12, nsess= 3)
res.cat2=catatis(Data= chang$Datafinal, nblo = 12, NameBlocks =  chang$NameSub)

#Vertical format without sessions
Data=PB_tuna[1:66,2:30]
chang2=change_cata_format2(Data, nprod= 6, nattr= 27, nsub = 11, nsess= 1)
res.cat3=catatis(Data= chang2$Datafinal, nblo = 11, NameBlocks =  chang2$NameSub)
res.clu3=cluscata(Data= chang2$Datafinal, nblo = 11, NameBlocks =  chang2$NameSub)

}
\seealso{
\code{\link{catatis}}, \code{\link{cluscata}}, \code{\link{change_cata_format}}
}
\keyword{CATA}
