% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-2-graph-construction.R
\name{get_highest_prune_param}
\alias{get_highest_prune_param}
\title{Calculate the highest pruning parameter for the SNN graph given NN matrix}
\usage{
get_highest_prune_param(nn_matrix, n_neigh)
}
\arguments{
\item{nn_matrix}{The adjacency matrix of the nearest neighbour graph.}

\item{n_neigh}{The number of nearest neighbours.}
}
\value{
A list with the following fields:
\itemize{
\item \code{prune_value}: The value of the highest pruning parameter.
\item \code{adj_matrix}: The adjacency matrix of the SNN graph after pruning.
}
}
\description{
Given a NN adjacency matrix, the function calculates the highest pruning
parameter for the SNN graph that preserves the connectivity of the graph.
}
\note{
Given the way the SNN graph is built, the possible values for the pruning
parameter are limited and can be determined by the formula \code{i / (2 * n_neigh - i)},
where \code{i} is a number of nearest neighbours between 0 and \code{n_neigh}.
}
\examples{
set.seed(2024)
# create an artificial pca embedding
pca_embedding <- matrix(
    c(runif(100 * 10), runif(100 * 10, min = 3, max = 4)),
    nrow = 200, byrow = TRUE
)
rownames(pca_embedding) <- as.character(1:200)
colnames(pca_embedding) <- paste("PC", 1:10)

# calculate the nn adjacency matrix
nn_matrix <- getNNmatrix(
    RANN::nn2(pca_embedding, k = 5)$nn.idx,
    5,
    0,
    -1
)$nn

get_highest_prune_param(nn_matrix, 5)$prune_value
}
