% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedrules.R
\name{schedrules}
\alias{schedrules}
\title{Schedules of awards of several rules}
\usage{
schedrules(d, claimant, Rules, col = NULL, points = 201, legend = TRUE)
}
\arguments{
\item{d}{A vector of claims.}

\item{claimant}{A claimant.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}

\item{col}{The colours. If col = NULL then the sequence of default colours is:
c("red", "blue", "green", "yellow", "pink", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{points}{The number of endowment values to draw the path.}

\item{legend}{A logical value. The colour legend is shown if legend = TRUE.}
}
\value{
The graphical representation of the schedules of awards of the rules for the claims vector and the same claimant.
}
\description{
This function returns the graphical representation of the schedules of awards of different rules for a claims vector and a given claimant.
}
\details{
Let \eqn{d\in \mathcal{R}^n}{d}, with \eqn{d\ge 0}, be a vector of claims and
 denote  \eqn{D=\sum_{i=1}^{n} d_i}{D=\sum di} the sum of claims.

The schedules of awards of a rule \eqn{R} for claimant \eqn{i} is the function \eqn{S} that assigns to each \eqn{E\in [0,D]}{0\le E \le D} the  value:
\eqn{S(E)=R_i(E,d)\in \mathcal{R}}{S(E)=Ri(E,d)}.
Therefore, the schedules of awards of a rule plots each claimants's award as a function of \eqn{E}.
}
\examples{
d=c(2,4,7,8)
claimant=2
Rules=c(Talmud,RA,AA)
col=c("red","green","blue")
schedrules(d,claimant,Rules,col)
}
\references{
Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{schedrule}, \link{pathawards}, \link{pathawards3}, \link{verticalruleplot}
}
