% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrimMorphDistMatrix.R
\name{TrimMorphDistMatrix}
\alias{TrimMorphDistMatrix}
\title{Trims a morphological distance matrix}
\usage{
TrimMorphDistMatrix(dist.matrix, Tree = NULL)
}
\arguments{
\item{dist.matrix}{A distance matrix in the format created by \link{MorphDistMatrix}.}

\item{Tree}{If the distance matrix includes ancestors this should be the tree (phylo object) used to reconstruct them.}
}
\value{
\item{DistMatrix}{A complete distance matrix with all cells filled. If there were no empty cells will return original.}
\item{Tree}{A tree (if supplied) with the removed taxa (see below) pruned. If no taxa are dropped will return the same tree as inputted. If no tree is supplied this is set to NULL.}
\item{RemovedTaxa}{A character vector listing the taxa removed. If none are removed this will be set to NULL.}
}
\description{
Trims a morphological distance matrix by removing objects that cause empty cells.
}
\details{
Trims a morphological distance matrix by removing nodes (terminal or internal) that cause empty cells allowing it to be passed to an ordination function such as \link{cmdscale}.

Some distances are not calculable from cladistic matrices if there are taxa that have no coded characters in common. This algorithm iteratively removes the taxa responsible for the most empty cells until the matrix is complete (no empty cells).

If the matrix includes reconstructed ancestors the user should also provide the tree used (as the \code{tree} argument). The function will then also remove the tips from the tree and where reconstructed ancestors also cause empty cells will prune the minimum number of descendants of that node. The function will then renumber the nodes in the distance matrix so they match the pruned tree.
}
\examples{

# Get morphological distances for Michaux (1989) data set:
distances <- MorphDistMatrix(Michaux1989)

# Attempt to trim max.dist.matrix:
TrimMorphDistMatrix(distances$DistanceMatrix)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
