% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupNcolor.R
\name{.groupNcolor}
\alias{.groupNcolor}
\title{Assign Group Membership and Colors for a Spectra or Spectra2D Object}
\usage{
.groupNcolor(spectra, gr.crit = NULL, gr.cols = "auto", mode = "1D")
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[ChemoSpec:Spectra]{ChemoSpec::Spectra()}} or \code{\link[ChemoSpec2D:Spectra2D]{ChemoSpec2D::Spectra2D()}}.}

\item{gr.crit}{As per \code{\link[ChemoSpec:files2SpectraObject]{ChemoSpec::files2SpectraObject()}}.}

\item{gr.cols}{As per \code{\link[ChemoSpec:files2SpectraObject]{ChemoSpec::files2SpectraObject()}}.}
}
\value{
A \emph{complete} object of S3 class \code{Spectra} or \code{\link[ChemoSpec2D]{Spectra2D}}.  This
function is the last internal step in creating these objects.
Until this function has done its job, these objects
will not pass checks as the assembly is not complete
(see \code{\link[ChemoSpecUtils]{chkSpectra}}).
}
\description{
\emph{Internal function}. A utility function which looks for \code{gr.crit} in the file names of .csv
files and assigns group membership.  Also assigns a color,
and for \code{Spectra} objects, a symbol and an
alternate symbol to each group.  Warnings are given if there are file names
that don't match entries in \code{gr.crit} or there are entries in
\code{gr.crit} that don't match any file names.  An internal function, not
generally called by the user.
}
\seealso{
\code{\link[ChemoSpec]{files2SpectraObject}} or
\code{files2Spectra2DObject}for details;
\code{\link[ChemoSpecUtils]{sumGroups}} to see the outcome.
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{internal}
