% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hats_alignSpectra2D.R
\name{hats_alignSpectra2D}
\alias{hats_alignSpectra2D}
\title{Align the Spectra in a Spectra2D Object using the HATS algorithm.}
\usage{
hats_alignSpectra2D(spectra, maxF2 = NULL, maxF1 = NULL,
  thres = 0.99, no.it = 20L, restarts = 2L, method = "MBO",
  fill = "noise", plot = FALSE, debug = 1)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}

\item{maxF2}{Integer.  The most extreme positive \code{F2step} to allow during the
alignment process (units are data points).  Search for the optimal alignment will
cover the region \code{-maxColShift} \ldots \code{maxColShift} and \code{-maxRowShift}
\ldots \code{maxRowShift}.}

\item{maxF1}{Integer.  As for \code{maxF2}, but for F1.}

\item{thres}{Numeric. Prior to launching the optimization, the objective function is evaluated
for no shift in case this is actually the best alignment (saving a great deal of time).
If this initial check exceeds the value of \code{thres}, no optimization is performed
and the unshifted spectra are returned.  The objective function is the cosine of the angle
between the unstacked spectra, so \code{thres} should be on [0 \ldots 1].}

\item{no.it}{Integer. The maximum number of iterations in the optimization.}

\item{restarts}{Integer. The maximum number of independent rounds of optimization.}

\item{method}{Character. Currently only \code{method = "MBO"} is available which uses
the HATS algorithm plus model based optimization (aka Bayesian optimzation) method to
align the spectra. Use \code{plot = TRUE} to see this in action.}

\item{fill}{Aligning spectra requires that at least some spectra be shifted left/right
      and up/down.  When a spectrum is shifted, spaces are opened that must be filled with something:
\itemize{
  \item If \code{fill = "zeros"} the spaces are filled with zeros.
  \item If \code{fill = "rnorm"} the spaces are filled with random noise.
  \item If \code{fill = "noise"} the spaces are filled with an estimate of the noise from the
    original spectrum.
}}

\item{plot}{Logical. Shall a plot of the alignment progress be made?  The plot is useful for
diagnostic purposes.  Every step of the alignment has a corresponding plot so you should
probably direct the output to a pdf file.}

\item{debug}{Integer.
\itemize{
  \item Values >= 1 give messages about alignment progress in black text.
  \item Values >= 2 print the merge matrix from the \code{hclust} object, if \code{plot}
        is also \code{TRUE}.  This is the guide tree.
  \item For \code{method = "MBO"} values less than 2 suppress some messages and warnings from
       the underlying functions.  If the alignment doesn't work well, set \code{debug = 2}.
  \item Setting \code{plot = TRUE} also gives a view of alignment diagnostics.
}}
}
\value{
An object of S3 class \code{\link{Spectra2D}}.
}
\description{
Align the spectra in a \code{\link{Spectra2D}} object using an implementation
of the HATS algorithm described by Robinette \emph{et al.}.  Currently, only
global, not local, alignment is carried out.
}
\examples{
\dontrun{
data(MUD2)
sumSpectra(MUD2)
# You might want to direct the diagnostic output here to a pdf file
# This alignment takes about 90 seconds including the plotting overhead
MUD2a <- hats_alignSpectra2D(MUD2, method = "MBO", debug = 1, plot = TRUE)
mylvls <- seq(3, 30, 3)
col1 <- rep("black", length(mylvls))
col2 <- rep("red", length(mylvls))
col3 <- rep("blue", length(mylvls))
col4 <- rep("green", length(mylvls))
plotSpectra2D(MUD2a, which = c(3, 6, 2, 5),
  lvls = list(mylvls, mylvls, mylvls, mylvls),
  cols = list(col1, col2, col3, col4))
}

}
\references{
Roughly follows the algorithm described in Robinette et al. 2011
  \emph{Anal. Chem.} vol. 83, 1649-1657 (2011) dx.doi.org/10.1021/ac102724x
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{multivariate}
