% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{GeoMean-class}
\alias{GeoMean-class}
\alias{.GeoMean}
\alias{GeoMean}
\alias{to_numeric,GeoMean-method}
\alias{.domain,GeoMean-method}
\alias{.grad,GeoMean-method}
\alias{name,GeoMean-method}
\alias{dim_from_args,GeoMean-method}
\alias{sign_from_args,GeoMean-method}
\alias{is_atom_convex,GeoMean-method}
\alias{is_atom_concave,GeoMean-method}
\alias{is_atom_log_log_convex,GeoMean-method}
\alias{is_atom_log_log_concave,GeoMean-method}
\alias{is_incr,GeoMean-method}
\alias{is_decr,GeoMean-method}
\alias{get_data,GeoMean-method}
\alias{copy,GeoMean-method}
\title{The GeoMean class.}
\usage{
GeoMean(x, p = NA_real_, max_denom = 1024)

\S4method{to_numeric}{GeoMean}(object, values)

\S4method{.domain}{GeoMean}(object)

\S4method{.grad}{GeoMean}(object, values)

\S4method{name}{GeoMean}(x)

\S4method{dim_from_args}{GeoMean}(object)

\S4method{sign_from_args}{GeoMean}(object)

\S4method{is_atom_convex}{GeoMean}(object)

\S4method{is_atom_concave}{GeoMean}(object)

\S4method{is_atom_log_log_convex}{GeoMean}(object)

\S4method{is_atom_log_log_concave}{GeoMean}(object)

\S4method{is_incr}{GeoMean}(object, idx)

\S4method{is_decr}{GeoMean}(object, idx)

\S4method{get_data}{GeoMean}(object)

\S4method{copy}{GeoMean}(object, args = NULL, id_objects = list())
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric vector.}

\item{p}{(Optional) A vector of weights for the weighted geometric mean. The default is a vector of ones, giving the \strong{unweighted} geometric mean \eqn{x_1^{1/n} \cdots x_n^{1/n}}.}

\item{max_denom}{(Optional) The maximum denominator to use in approximating \code{p/sum(p)} with \code{w}. If \code{w} is not an exact representation, increasing \code{max_denom} may offer a more accurate representation, at the cost of requiring more convex inequalities to represent the geometric mean. Defaults to 1024.}

\item{object}{A \linkS4class{GeoMean} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}

\item{args}{An optional list that contains the arguments to reconstruct the atom. Default is to use current arguments of the atom.}

\item{id_objects}{Currently unused.}
}
\description{
This class represents the (weighted) geometric mean of vector \eqn{x} with optional powers given by \eqn{p}.
}
\details{
\deqn{\left(x_1^{p_1} \cdots x_n^{p_n} \right)^{\frac{1}{\mathbf{1}^Tp}}}

The geometric mean includes an implicit constraint that \eqn{x_i \geq 0} whenever \eqn{p_i > 0}. If \eqn{p_i = 0, x_i} will be unconstrained.
The only exception to this rule occurs when \eqn{p} has exactly one nonzero element, say \eqn{p_i}, in which case \code{GeoMean(x,p)} is equivalent to \eqn{x_i} (without the nonnegativity constraint).
A specific case of this is when \eqn{x \in \mathbf{R}^1}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The (weighted) geometric mean of the elements of \code{x}.

\item \code{.domain}: Returns constraints describing the domain of the node

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{name}: The name and arguments of the atom.

\item \code{dim_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The atom is non-negative.

\item \code{is_atom_convex}: The atom is not convex.

\item \code{is_atom_concave}: The atom is concave.

\item \code{is_atom_log_log_convex}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave}: Is the atom log-log concave?

\item \code{is_incr}: The atom is weakly increasing in every argument.

\item \code{is_decr}: The atom is not weakly decreasing in any argument.

\item \code{get_data}: Returns \code{list(w, dyadic completion, tree of dyads)}.

\item \code{copy}: Returns a shallow copy of the GeoMean atom
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric vector.}

\item{\code{p}}{(Optional) A vector of weights for the weighted geometric mean. The default is a vector of ones, giving the \strong{unweighted} geometric mean \eqn{x_1^{1/n} \cdots x_n^{1/n}}.}

\item{\code{max_denom}}{(Optional) The maximum denominator to use in approximating \code{p/sum(p)} with \code{w}. If \code{w} is not an exact representation, increasing \code{max_denom} may offer a more accurate representation, at the cost of requiring more convex inequalities to represent the geometric mean. Defaults to 1024.}

\item{\code{w}}{(Internal) A list of \code{bigq} objects that represent a rational approximation of \code{p/sum(p)}.}

\item{\code{approx_error}}{(Internal) The error in approximating \code{p/sum(p)} with \code{w}, given by \eqn{\|p/\mathbf{1}^Tp - w\|_{\infty}}.}
}}

