% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{SCS-class}
\alias{SCS-class}
\alias{SCS}
\alias{mip_capable,SCS-method}
\alias{status_map,SCS-method}
\alias{name,SCS-method}
\alias{import_solver,SCS-method}
\alias{reduction_format_constr,SCS-method}
\alias{perform,SCS,Problem-method}
\alias{invert,SCS,list,list-method}
\alias{solve_via_data,SCS-method}
\title{An interface for the SCS solver}
\usage{
SCS()

\S4method{mip_capable}{SCS}(solver)

\S4method{status_map}{SCS}(solver, status)

\S4method{name}{SCS}(x)

\S4method{import_solver}{SCS}(solver)

\S4method{reduction_format_constr}{SCS}(object, problem, constr, exp_cone_order)

\S4method{perform}{SCS,Problem}(object, problem)

\S4method{invert}{SCS,list,list}(object, solution, inverse_data)

\S4method{solve_via_data}{SCS}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{SCS} object.}

\item{status}{A status code returned by the solver.}

\item{problem}{A \linkS4class{Problem} object.}

\item{constr}{A \linkS4class{Constraint} to format.}

\item{exp_cone_order}{A list indicating how the exponential cone arguments are ordered.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A list containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance on the primal and dual residual.}

\item{reltol}{The relative tolerance on the duality gap.}

\item{abstol}{The absolute tolerance on the duality gap.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the SCS solver
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable(SCS)}: Can the solver handle mixed-integer programs?

\item \code{status_map(SCS)}: Converts status returned by SCS solver to its respective CVXPY status.

\item \code{name(SCS)}: Returns the name of the solver

\item \code{import_solver(SCS)}: Imports the solver

\item \code{reduction_format_constr(SCS)}: Return a linear operator to multiply by PSD constraint coefficients.

\item \code{perform(object = SCS, problem = Problem)}: Returns a new problem and data for inverting the new solution

\item \code{invert(object = SCS, solution = list, inverse_data = list)}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data(SCS)}: Solve a problem represented by data returned from apply.

}}
