% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{SOCAxis-class}
\alias{SOCAxis-class}
\alias{.SOCAxis}
\alias{SOCAxis}
\alias{SOCAxis}
\alias{as.character,SOCAxis-method}
\alias{format_constr,SOCAxis-method}
\alias{num_cones,SOCAxis-method}
\alias{cone_size,SOCAxis-method}
\alias{size,SOCAxis-method}
\title{The SOCAxis class.}
\usage{
SOCAxis(t, X, axis)

\S4method{as.character}{SOCAxis}(x)

\S4method{format_constr}{SOCAxis}(object, eq_constr, leq_constr, dims, solver)

\S4method{num_cones}{SOCAxis}(object)

\S4method{cone_size}{SOCAxis}(object)

\S4method{size}{SOCAxis}(object)
}
\arguments{
\item{t}{The scalar part of the second-order constraint.}

\item{X}{A matrix whose rows/columns are each a cone.}

\item{axis}{The dimension across which to take the slice: \code{1} indicates rows, and \code{2} indicates columns.}

\item{x, object}{A \linkS4class{SOCAxis} object.}

\item{eq_constr}{A list of the equality constraints in the canonical problem.}

\item{leq_constr}{A list of the inequality constraints in the canonical problem.}

\item{dims}{A list with the dimensions of the conic constraints.}

\item{solver}{A string representing the solver to be called.}
}
\description{
This class represents a second-order cone constraint for each row/column.
It Assumes \eqn{t} is a vector the same length as \eqn{X}'s rows (columns) for axis == 1 (2).
}
\section{Methods (by generic)}{
\itemize{
\item \code{format_constr}: Format SOC constraints as inequalities for the solver.

\item \code{num_cones}: The number of elementwise cones.

\item \code{cone_size}: The dimensions of a single cone.

\item \code{size}: The dimensions of the (elementwise) second-order cones.
}}

\section{Slots}{

\describe{
\item{\code{constr_id}}{(Internal) A unique integer identification number used internally.}

\item{\code{t}}{The scalar part of the second-order constraint.}

\item{\code{x_elems}}{A list containing \code{X}, a matrix whose rows/columns are each a cone.}

\item{\code{axis}}{The dimension across which to take the slice: \code{1} indicates rows, and \code{2} indicates columns.}
}}

