% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant.R
\docType{class}
\name{CallbackParam-class}
\alias{CallbackParam-class}
\alias{.CallbackParam}
\alias{CallbackParam}
\alias{CallbackParam}
\alias{value,CallbackParam-method}
\alias{get_data,CallbackParam-method}
\title{The CallbackParam class.}
\usage{
CallbackParam(callback, rows = 1, cols = 1, name = NA_character_,
  sign = UNKNOWN)

\S4method{value}{CallbackParam}(object)

\S4method{get_data}{CallbackParam}(object)
}
\arguments{
\item{callback}{A numeric element, vector, matrix, or data.frame}

\item{rows}{The number of rows in the parameter.}

\item{cols}{The number of columns in the parameter.}

\item{name}{(Optional) A character string representing the name of the parameter.}

\item{sign}{A character string indicating the sign of the parameter. Must be "ZERO", "POSITIVE", "NEGATIVE", or "UNKNOWN".}

\item{object}{A \linkS4class{CallbackParam} object.}
}
\description{
This class represents a parameter whose value is obtained by evaluating a function.
}
\section{Methods (by generic)}{
\itemize{
\item \code{get_data}: Returns \code{list(callback, rows, cols, name, sign string)}.
}}

\section{Slots}{

\describe{
\item{\code{callback}}{A numeric element, vector, matrix, or data.frame.}
}}

\examples{
x <- Variable(2)
dim <- size(x)
y <- CallbackParam(value(x), dim[1], dim[2], sign = "POSITIVE")
get_data(y)
}
