% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/atoms.R
\docType{methods}
\name{curvature-atom}
\alias{curvature-atom}
\alias{is_atom_convex}
\alias{is_atom_concave}
\alias{is_atom_affine}
\alias{is_atom_convex,Atom-method}
\alias{is_atom_concave,Atom-method}
\alias{is_atom_affine,Atom-method}
\title{Curvature of an Atom}
\usage{
is_atom_convex(object)

is_atom_concave(object)

is_atom_affine(object)

\S4method{is_atom_convex}{Atom}(object)

\S4method{is_atom_concave}{Atom}(object)

\S4method{is_atom_affine}{Atom}(object)
}
\arguments{
\item{object}{A \linkS4class{Atom} object.}
}
\value{
A logical value.
}
\description{
Determine if an atom is convex, concave, or affine.
}
\examples{
x <- Variable()

is_atom_convex(x^2)
is_atom_convex(sqrt(x))
is_atom_convex(log(x))

is_atom_concave(-abs(x))
is_atom_concave(x^2)
is_atom_concave(sqrt(x))

is_atom_affine(2*x)
is_atom_affine(x^2)
}
