% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cubshevisual.R
\name{cubshevisual}
\alias{cubshevisual}
\title{Plot an estimated CUB model with shelter}
\usage{
cubshevisual(ordinal,shelter,csiplot=FALSE,paiplot=FALSE,...)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{shelter}{Category corresponding to the shelter choice}

\item{csiplot}{Logical: should \eqn{\xi} or \eqn{1-\xi} be the \eqn{y} coordinate}

\item{paiplot}{Logical: should \eqn{\pi} or \eqn{1-\pi} be the \eqn{x} coordinate}

\item{...}{Additional arguments to be passed to \code{plot()} and \code{text()}. Optionally, the number \code{m}
of ordinal categories may be passed: this is recommended if some category has zero frequency.}
}
\value{
For a CUB model with shelter fitted to \code{ordinal}, by default it returns a plot of the estimated
\eqn{(1-\pi, 1-\xi)} as a point in the parameter space, labeled with the estimated shelter parameter \eqn{\delta}.
Depending on \code{csiplot} and \code{paiplot} and on desired output, \eqn{x} and \eqn{y} coordinates may be set
to \eqn{\pi} and \eqn{\xi}, respectively.
}
\description{
Plotting facility for the CUB estimation of ordinal responses when a shelter effect is included
}
\details{
It represents an estimated CUB model with shelter effect as a point
 in the parameter space with shelter estimate indicated as label.
}
\examples{
data(univer)
ordinal<-univer$global
cubshevisual(ordinal,shelter=7,digits=3,col="blue",main="Global Satisfaction")
}
\seealso{
\code{\link{cubvisual}}, \code{\link{multicub}}
}
\keyword{device}

