#' @title Auxiliary function for the log-likelihood estimation of CUBE models without covariates
#' @description Define the opposite of the scalar function that is maximized when running the E-M 
#' algorithm for CUBE models without covariates.
#' @aliases effecube
#' @usage effecube(paravec, dati, m)
#' @param paravec Vector of initial estimates for the feeling and the overdispersion parameters
#' @param dati Matrix binding together a column vector of length \eqn{m} containing the posterior
#'  probabilities that each observed category has been generated by the first component distribution 
#'  of the mixture, and the column vector of the absolute frequencies of the observations
#' @keywords internal 
#' @details It is called as an argument for optim within CUBE function (where no covariate is specified)
#'  and "cubeforsim" as the function to minimize.
#' @references Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data,
#'  \emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786 \cr


effecube <- function(paravec,dati,m){
  tauno<-dati[,1]
  freq<-dati[,2]
  return(-sum(freq*tauno*log(betar(m,paravec[1],paravec[2]))))
}
