% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubshevisual.R
\name{cubshevisual}
\alias{cubshevisual}
\title{Plot an estimated CUB model with shelter}
\usage{
cubshevisual(ordinal,shelter,...)
}
\arguments{
\item{ordinal}{Vector of ordinal responses (factor type)}

\item{shelter}{Category corresponding to the shelter choice}

\item{...}{Additional arguments to be passed to plot() and text()}
}
\value{
A plot of the estimated parameter vector \eqn{(\pi, \xi)} as a point in the parameter space, 
 labeled with the shelter parameter \eqn{\delta}.
}
\description{
Plotting facility for the CUB estimation of ordinal responses when a shelter effect is included
}
\details{
It represents an estimated CUB model with shelter effect as a point
 in the parameter space with shelter parameter indicated as label.
}
\examples{
data(univer)
attach(univer)
cubshevisual(global,shelter=7,digits=3,col="blue")
}
\seealso{
\code{\link{cubvisual}}, \code{\link{multicub}}
}
\keyword{device}

