% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPGLIB_Plot_Functions.R
\name{plot.cv.CPGLIB}
\alias{plot.cv.CPGLIB}
\title{Plot of coefficients paths for cv.CPGLIB Object}
\usage{
\method{plot}{cv.CPGLIB}(
  x,
  group_index = NULL,
  plot_type = c("Coef", "CV-Error")[1],
  active_only = TRUE,
  path_type = c("Log-Lambda", "L1-Norm")[1],
  labels = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class cv.CPGLIB.}

\item{group_index}{The group for which to return the coefficients. Default is the ensemble coefficients.}

\item{plot_type}{Plot of coefficients, "Coef", or cross-validated error or deviance, "CV-Error". Default is "Coef".}

\item{active_only}{Only include the variables selected in final model. Default is TRUE.}

\item{path_type}{Plot of coefficients paths as a function of either "Log-Lambda" or "L1-Norm". Default is "Log-Lambda".}

\item{labels}{Include the labels of the variables. Default is FALSE.}

\item{...}{Additional arguments for compatibility.}
}
\value{
The coefficients or the cross-validation errors plot for a cv.CPGLIB object.
}
\description{
\code{plot.cv.CPGLIB} returns the coefficients for a cv.CPGLIB object, or a cross-validation errors plot.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
n <- 50
N <- 2000
p <- 300
beta.active <- c(abs(runif(p, 0, 1/2))*(-1)^rbinom(p, 1, 0.3))
# Parameters
p.active <- 150
beta <- c(beta.active[1:p.active], rep(0, p-p.active))
Sigma <- matrix(0, p, p)
Sigma[1:p.active, 1:p.active] <- 0.5
diag(Sigma) <- 1

# Train data
x.train <- mvnfast::rmvn(n, mu = rep(0, p), sigma = Sigma) 
prob.train <- exp(x.train \%*\% beta)/
              (1+exp(x.train \%*\% beta))
y.train <- rbinom(n, 1, prob.train)
# Test data
x.test <- mvnfast::rmvn(N, mu = rep(0, p), sigma = Sigma)
prob.test <- exp(x.test \%*\% beta)/
             (1+exp(x.test \%*\% beta))
y.test <- rbinom(N, 1, prob.test)

# SplitGLM - CV (Multiple group_index)
cpg.out <- cv.cpg(x.train, y.train,
                  glm_type = "Logistic",
                  G = 10, include_intercept = TRUE,
                  alpha_s = 3/4, alpha_d = 1,
                  n_lambda_sparsity = 50, n_lambda_diversity = 50,
                  tolerance = 1e-3, max_iter = 1e3,
                  n_folds = 5,
                  n_threads = 1)
                         
# Plot of coefficients paths (function of Log-Lambda)
plot(cpg.out, plot_type = "Coef", path_type = "Log-Lambda", group_index = 1, labels = FALSE)

# Plot of coefficients paths (function of L1-Norm)
plot(cpg.out, plot_type = "Coef", path_type = "L1-Norm", group_index = 1, labels = FALSE)

# Plot of CV error
plot(cpg.out, plot_type = "CV-Error")

}

}
\seealso{
\code{\link{cv.cpg}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
