% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_delta_f.R
\name{q_delta_f}
\alias{q_delta_f}
\title{M-Step Expected Log-Likelihood with respect to Delta}
\usage{
q_delta_f(
  delta_v,
  V,
  obs_Ystar_matrix,
  obs_Ytilde_matrix,
  w_mat,
  sample_size,
  n_cat
)
}
\arguments{
\item{delta_v}{A numeric array of regression parameters for the second-stage observed
outcome mechanism, \eqn{\tilde{Y} | Y^*, Y}
(second-stage observed outcome, given the first-stage observed outcome and the true outcome) ~ \code{V} (misclassification
predictor matrix). The \eqn{\delta} vector is obtained from the array form. In array form,
the first dimension (matrix rows) of \code{delta}
corresponds to parameters for the \eqn{\tilde{Y} = 1}
second-stage observed outcome, with the dimensions of the \code{V}
The second dimension (matrix columns) correspond to the first-stage
observed outcome categories \eqn{Y^* \in \{1, 2\}}. The third dimension of
\code{delta_start} corresponds to to the true outcome categories
\eqn{Y \in \{1, 2\}}. The numeric vector \eqn{\delta} is obtained by
concatenating the delta array, i.e. \code{delta_v <- c(delta_array)}.}

\item{V}{A numeric design matrix.}

\item{obs_Ystar_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{obs_Ytilde_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \eqn{\tilde{Y}}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{w_mat}{Matrix of E-step weights obtained from \code{w_j_2stage}.}

\item{sample_size}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{V}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcomes can take.}
}
\value{
\code{q_beta_f} returns the negative value of the expected log-likelihood function,
\eqn{Q_{\delta} = \sum_{i = 1}^N \Bigl[\sum_{j = 1}^2 \sum_{k = 1}^2 \sum_{\ell = 1}^2 w_{ij} y^*_{ik} \tilde{y}_{i \ell} \text{log} \{ \tilde{\pi}_{i \ell kj} \}\Bigr]},
at the provided inputs.
}
\description{
Objective function of the form:
\eqn{Q_{\delta} = \sum_{i = 1}^N \Bigl[\sum_{j = 1}^2 \sum_{k = 1}^2 \sum_{\ell = 1}^2 w_{ij} y^*_{ik} \tilde{y}_{i \ell} \text{log} \{ \tilde{\pi}_{i \ell kj} \}\Bigr]}.
Used to obtain estimates of \eqn{\delta} parameters.
}
