% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{applyLoewe}
\alias{applyLoewe}
\title{This function calculates Loewe synergy/antagonism and associated BIs}
\usage{
applyLoewe(rawDataPreProcessed, xConcentration, yConcentration, nBoot)
}
\arguments{
\item{rawDataPreProcessed}{Raw preprocessed experimental data}

\item{xConcentration}{X drug concentrations}

\item{yConcentration}{Y drug concentrations}

\item{nBoot}{Number of times to bootstrap}
}
\value{
Three lists, first list consisting of Loewe Synergy/Antagonism, lower bound of BI and  
upper bound of BI. 2nd list consists of global BI for maximum synergy and 3rd list 
consists of global BI of maximum antagonistic combination.
}
\description{
This function calculates Loewe synergy/antagonism and associated BIs
}
\examples{
\dontrun{
dataFile <- system.file("extdata", "rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE )
xConc  <- c(0.00,  0.20,  0.39,  0.78,  1.56,3.12,  6.25, 12.50, 25.00, 50) 
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
noOFBoot <- 500 # a large number is recomended
rslt <- applyLoewe(as.matrix(dataSample), xConc, yConc, noOFBoot)
}
}
\author{
Muhammad kashif
}
