% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{plot_uncertainty}
\alias{plot_uncertainty}
\title{Plot ranks from an uncertainty/sensitivity analysis}
\usage{
plot_uncertainty(
  SAresults,
  plot_units = NULL,
  order_by = "nominal",
  dot_colour = NULL,
  line_colour = NULL
)
}
\arguments{
\item{SAresults}{A list of sensitivity/uncertainty analysis results from \code{\link[=get_sensitivity]{get_sensitivity()}}.}

\item{plot_units}{A character vector of units to plot. Defaults to all units. You can also set
to \code{"top10"} to only plot top 10 units, and \code{"bottom10"} for bottom ten.}

\item{order_by}{If set to \code{"nominal"}, orders the rank plot by nominal ranks
(i.e. the original ranks prior to the sensitivity analysis). Otherwise if \code{"median"}, orders by
median ranks.}

\item{dot_colour}{Colour of dots representing median ranks.}

\item{line_colour}{Colour of lines connecting 5th and 95th percentiles.}
}
\value{
A plot of rank confidence intervals, generated by 'ggplot2'.
}
\description{
Plots the ranks resulting from an uncertainty and sensitivity analysis, in particular plots
the median, and 5th/95th percentiles of ranks.
}
\details{
To use this function you first need to run \code{\link[=get_sensitivity]{get_sensitivity()}}. Then enter the resulting list as the
\code{SAresults} argument here.

See \code{vignette("sensitivity")}.
}
\examples{
# for examples, see `vignette("sensitivity")`
# (this is because package examples are run automatically and sensitivity analysis
# can take a few minutes to run at realistic settings)

}
\seealso{
\itemize{
\item \code{\link[=get_sensitivity]{get_sensitivity()}} Perform global sensitivity or uncertainty analysis on a coin
\item \code{\link[=plot_sensitivity]{plot_sensitivity()}} Plot sensitivity indices following a sensitivity analysis.
}
}
