% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{varInf}
\alias{varInf}
\title{@encoding UTF-8
Perform variational inference sampling}
\usage{
varInf(
  countData,
  starts,
  ends,
  algorithm = "meanfield",
  output_samples = 500,
  params_to_save = c("pi", "p")
)
}
\arguments{
\item{countData}{A matrix or data frame of counts, must only include numeric data. Data should be arranged so that the first n rows correspond to one treatment group and the next n rows correspond with the next treatment group, and so on. The row indices for the first and last sample in these groups are fed into this function via 'starts' and 'ends'.}

\item{starts}{A vector defining the indices that correspond to the first sample in each treatment group.}

\item{ends}{A vector defining the indices that correspond to the last sample in each treatment group.}

\item{algorithm}{The algorithm to use when performing variational inference. Either 'meanfield' or 'fullrank'. The former is the default.}

\item{output_samples}{The number of samples from the approximated posterior to save.}

\item{params_to_save}{The parameters from which to save samples. Can be 'p', 'pi', 'theta'.}
}
\value{
A fitted 'Stan' object that includes the samples from the parameters designated.
}
\description{
This function uses a compiled Dirichlet multinomial model and performs variational inference estimation of posteriors using 'Stan'.
Evaluating the performance of variational inference is currently under development per our understanding. Please roll over to the 'Stan' website and see if new diagnostics are available.
If you use this function then credit 'Stan' and 'RStan' along with this package.
}
\details{
Warning: data must be input in the correct organized format or this function will not provide accurate results. See vignette if you are unsure how to organize data.
Warning: depending upon size of data to be analyzed this function can take a very long time to run.
}
\examples{
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
names(com_demo) <- rep("name", 10)
varInf(com_demo,starts = c(1,6), ends=c(5,10))
}
