% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_towers.R
\name{financial_cof_towers}
\alias{financial_cof_towers}
\title{Financial cost of Failure for Towers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_towers(
  tower_asset_category,
  type_financial_factor_criteria,
  access_factor_criteria
)
}
\arguments{
\item{tower_asset_category}{String The type of tower asset category
Options: \code{tower_asset_category = c("33kV Tower", "66kV Tower",
"132kV Tower")}.}

\item{type_financial_factor_criteria}{String The type financial factor for Tower
\code{type_financial_factor_criteria = c("Suspension", "Tension", "Terminal")}.}

\item{access_factor_criteria}{String. Asses Financial factor criteria for Tower
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B")}.}
}
\value{
Numeric. Financial consequences of failure for Poles
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_towers(tower_asset_category = "33kV Tower",
type_financial_factor_criteria = "Suspension",
access_factor_criteria = "Type A")
}
