% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_ehv_cables.R
\name{safety_cof_ehv_cables}
\alias{safety_cof_ehv_cables}
\title{Safety cost of Failure for EHV UG cabkes & 132 kV UG cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
safety_cof_ehv_cables(ehv_asset_category)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV asset category}
}
\value{
Numeric. Financial consequences of failure for EEHV UG cabkes & 132 kV UG cables
}
\description{
This function calculates safety consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Safety consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
safety_cof_ehv_cables(ehv_asset_category = "33kV UG Cable (Oil)")
}
