% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformers.R
\name{environmental_cof_transformers}
\alias{environmental_cof_transformers}
\title{Environmental cost of Failure for Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
environmental_cof_transformers(
  tf_asset_category,
  prox_water,
  bunded,
  size_kva_mva = NULL,
  size_conversion = NULL
)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m
(cf. table 223, page 172, CNAIM, 2017).}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}

\item{size_kva_mva}{Numeric The MVA KVA rating for the transformer}

\item{size_conversion}{String The size conversion for the transfromer}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV switchgear
}
\examples{
environmental_cof_transformers(tf_asset_category = "33kV Transformer (GM)",
prox_water = 95, bunded = "Yes", size_kva_mva = 20, size_conversion = "33/20kV")
}
