% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_cof_tf.R
\name{e_cof_tf}
\alias{e_cof_tf}
\title{Environmental Consequences of Failure for transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
e_cof_tf(
  asset_type_tf,
  rated_capacity = "Default",
  prox_water = "Default",
  bunded = "Default"
)
}
\arguments{
\item{asset_type_tf}{String. Transformer types.
Options:
\code{asset_type_tf = c("6.6/11kV Transformer (GM)",
"20kV Transformer (GM)", "33kV Transformer (GM)",
"66kV Transformer (GM)", "132kV Transformer (GM)")}.}

\item{rated_capacity}{Numeric. The rated capacity for a transformer. For type
\code{"6.6/11kV Transformer (GM)"} and \code{"20kV Transformer (GM)"} use kVA
ratings. For \code{"20kV Transformer (GM)", "33kV Transformer (GM)",
"66kV Transformer (GM)", "132kV Transformer (GM)"} use MVA ratings.
A setting of \code{"Default"} will result in a
size environmental factor of 1 (cf. table 222, page 171, CNAIM, 2017).}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m
(cf. table 223, page 172, CNAIM, 2017).}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\value{
Numeric. Financial cost of failure for a 10kV transformer.
}
\description{
This function calculates environmental consequences of failure
for all type of transformers.
(cf. section 7.5, page 80, CNAIM, 2017). Environmental consequences
 of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
# Environmental consequences of failure for a 6.6/11 kV transformer
e_cof_tf(asset_type_tf = "6.6/11kV Transformer (GM)",
rated_capacity = 750, prox_water = 100, bunded = "Yes")
}
