% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvdata_plot.R
\name{plot.clv.data}
\alias{plot.clv.data}
\title{Plot actual repeat transactions}
\usage{
\method{plot}{clv.data}(
  x,
  prediction.end = NULL,
  cumulative = FALSE,
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{The clv data object to plot}

\item{prediction.end}{Until what point in time to predict. This can be the number of periods (numeric) or a form of date/time object. See details.}

\item{cumulative}{Whether the cumulative actual repeat transactions should be plotted.}

\item{plot}{Whether a plot should be created or only the assembled data returned.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}
}
\value{
An object of class \code{ggplot} from package \code{ggplot2} is returned by default.
If the parameter \code{plot} is \code{FALSE}, the data that would have been melted and used to
create the plot is returned. It is a \code{data.table} which contains the following columns:
\item{period.until}{The timepoint that marks the end (up until and including) of the period to which the data in this row refers.}
\item{Number of Repeat Transactions}{The number of actual repeat transactions in
the period that ends at \code{period.until}.}
}
\description{
Plots the actual repeat transactions for the given CLV data object.
}
\details{
\code{prediction.end} indicates until when to predict or plot and can be given as either
a point in time (of class \code{Date}, \code{POSIXct}, or \code{character}) or the number of periods.
If \code{prediction.end} is of class character, the date/time format set when creating the data object is used for parsing.
If \code{prediction.end} is the number of periods, the end of the fitting period serves as the reference point
from which periods are counted. Only full periods may be specified.
If \code{prediction.end} is omitted or NULL, it defaults to the end of the holdout period if present and to the
end of the estimation period otherwise.

The first prediction period is defined to start right after the end of the estimation period.
If for example weekly time units are used and the estimation period ends on Sunday 2019-01-01, then the first day
of the first prediction period is Monday 2019-01-02. Each prediction period includes a total of 7 days and
the first prediction period therefore will end on, and include, Sunday 2019-01-08. Subsequent prediction periods
again start on Mondays and end on Sundays.
If \code{prediction.end} indicates a timepoint on which to end, this timepoint is included in the prediction period.

If there are no repeat transactions until \code{prediction.end}, only the time for which there is data
is plotted. If the data is returned (ie with argument \code{plot=FALSE}), the respective rows
contain \code{NA} in column \code{Number of Repeat Transactions}.
}
\examples{

data("cdnow")
clv.data.cdnow <- clvdata(cdnow, time.unit="w",
                          estimation.split=37,
                          date.format="ymd")

# Plot the actual repeat transactions
plot(clv.data.cdnow)

# plot cumulative repeat transactions
plot(clv.data.cdnow, cumulative=TRUE)

# Dont automatically plot but tweak further
gg.cdnow <- plot(clv.data.cdnow)

# change Title
library(ggplot2)
gg.cdnow + ggtitle("CDnow repeat transactions")

# Dont return a plot but only the data from
#   which it would have been created
dt.plot.data <- plot(clv.data.cdnow, plot=FALSE)


}
