% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slurp_spip.R
\name{slurp_spip}
\alias{slurp_spip}
\title{Read in the pedigree, census, and sampling information from the spip run}
\usage{
slurp_spip(dir, num_generations)
}
\arguments{
\item{dir}{the path to the directory where spip was run.  This is
returned by \code{run_spip()}.}

\item{num_generations}{how many generations back do you wish to consider
for find relatives of
each sampled individual.  0 means just the individual themselves (so, not very
interesting, and you likely wouldn't ever use it. 1 means up to
and including the parents; 2 means up to and including the grandparents; 3 means up to
and including the great grandparents; and so forth.}
}
\value{
A list of tibbles.  Each tibble is a named component of
the return list.  The names are as follows:
\itemize{
\item \code{pedigree}
\item \code{census_prekill},
\item \code{census_postkill},
\item \code{samples},
\item \code{deaths},
\item \code{genotypes},
\item \code{migrants}
}

You can inspect some example output in
the package data object \code{three_pops_with_mig_slurped_results}
}
\description{
This function is run after \code{run_spip()}.  It assumes that \code{run_spip()}
has left the files: \code{spip_pedigree.tsv}, \code{spip_prekill_census.tsv}, and
\code{spip_samples.tsv}, \code{spip_postkill_census.tsv}, \code{spip_deaths.tsv},
\code{spip_genotypes.tsv}, and \code{spip_migrants.tsv}
inside the directory where \code{run_spip()} was run.
}
\details{
For an example of its use, see the Vignette:
\code{vignette("species_1_simulation", package = "CKMRpop")}.
}
\examples{
# see Vignette: vignette("species_1_simulation", package = "CKMRpop")
}
