% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explained_variance.R
\name{compute_expl_var}
\alias{compute_expl_var}
\title{Phenotypic variance explained by genetic variants.}
\usage{
compute_expl_var(genodata = NULL, phenodata = NULL,
  type = "Rsquared_unadj", causal_idx = NULL, effect_causal = NULL)
}
\arguments{
\item{genodata}{Numeric vector or dataframe containing the genetic variant(s) in
columns. Must be in allelic coding 0, 1, 2.}

\item{phenodata}{Numeric vector or dataframe of the phenotype.}

\item{type}{String (vector) specifying the estimation approach(es) that are computed.
Available are the methods \code{"Rsquared_unadj"},
\code{"Rsquared_adj"}, \code{"MAF_based"}, and
\code{"MAF_based_Y_adjusted"}. See below for more details.}

\item{causal_idx}{Vector with entries \code{TRUE}, \code{FALSE} specifying which
SNVs are causal. Has to be supplied for the approaches
\code{MAF_based} and \code{MAF_based_Y_adjusted}.}

\item{effect_causal}{Numeric vector containing the effect sizes of the causal SNVs.
Has to be supplied for the approaches \code{MAF_based} and
\code{MAF_based_Y_adjusted}.}
}
\value{
A list containing the estimated percentage of explained phenotypic variance.
}
\description{
Function to estimate the percentage of the variance of a phenotype
that can be explained by given single nucleotide variants
(SNVs).
}
\details{
Four different approaches are available to estimate the percentage of
explained phenotypic variance (Laird & Lange, 2011):

(1) \code{"Rsquared_unadj"}: Unadjusted \eqn{R^2}{R2} from a linear regression of
    the phenotype conditional on all provided SNVs.

(2) \code{"Rsquared_adj"}: Adjusted \eqn{R^2}{R2} from a linear regression of
    the phenotype conditional on all provided SNVs.

(3) \code{"MAF_based"}: Expected explained phenotypic variance computed based on the
    MAF and effect size of the provided causal SNVs.

(4) \code{"MAF_based_Y_adjusted"}: Expected explained phenotypic variance computed
    based on the MAF and effect size of the causal SNVs, with respect to the empirical
    phenotypic variance, which is the broad-sense heritability relative to the
    empirical phenotypic variance.

References:

Laird NM, Lange C (2011). The fundamentals of modern statistical genetics. New York: Springer.
}
\examples{

genodata <- generate_genodata(n_SNV = 20, n_ind = 1000)
phenodata <- generate_phenodata_1_simple(genodata = genodata[,1],
                                         type = "quantitative", b = 0)
compute_expl_var(genodata = genodata, phenodata = phenodata$Y,
                 type = c("Rsquared_unadj", "Rsquared_adj"),
                 causal_idx = NULL, effect_causal = NULL)

}
