% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{pca_centralities}
\alias{pca_centralities}
\title{Ranking centrality measure based on contributions}
\usage{
pca_centralities(x, scale.unit = TRUE, cut.off = 80, ncp = 5,
  graph = FALSE, axes = c(1, 2))
}
\arguments{
\item{x}{a list containg the computed centrality values}

\item{scale.unit}{a boolean constant, whether data should be scaled to unit
variance(default=TRUE)}

\item{cut.off}{The intensity that must be exceeded in cumulative percentage of variance of eigen values.(default=80)}

\item{ncp}{number of dimensions in final results (default=5)}

\item{graph}{a boolean constant, whether the graph shoul be displayed}

\item{axes}{a length 2 vector describing the number of components to plot(default=c(1,2))}
}
\value{
a plot illustrating significant centralities in the order of contribution
}
\description{
This function demonstrates ranks of centrality measures in order of information levels.
}
\details{
This function represents centralities in the ranking list based on variable contribution to
make principal components.
PCA is a method for drawing out important variables from a data set.
It helps user to reduced the dimensions in high dimensional data.
It is more common to use for more than 3 dimensional datasets.
}
\references{
Husson, F., Lê, S., & Pagès, J. (2010). Exploratory Multivariate Analysis by Example using R. Chapman & Hall/CRC Computer Science & Data Analysis, 40(April), 240.

http://www.sthda.com/english/
}
\seealso{
\code{\link[FactoMineR]{PCA}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
