% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.R
\name{sa}
\alias{sa}
\title{Flexible Monte Carlo sensitivity analysis for unmeasured confounding}
\usage{
sa(
  x,
  y,
  w,
  prior_c_function,
  M1,
  M2 = NULL,
  nCores,
  estimand,
  reference_trt,
  ...
)
}
\arguments{
\item{x}{dataframe including the treatment indicator and the covariates}

\item{y}{numeric vector for the binary outcome}

\item{w}{numeric vector for the treatment indicator}

\item{prior_c_function}{could be 1) a vector of characters indicating the prior distributions for the confounding functions.  Each character contains the random number generation code from the standard probability distributions in the stats package.  2) a vector of characters including the grid specifications for the confounding functions. It should be used  when  users  want  to  formulate  the  confounding  functions  as  scalar  values. 3)A matrix indicating the point mass prior for the confounding functions}

\item{M1}{a numeric value indicating the number of draws of the GPS from their posterior predictive distribution}

\item{M2}{a numeric value indicating the number of draws from the prior distributions of the confounding functions}

\item{nCores}{number of cores to use for parallel computing}

\item{estimand}{is a character string ("ATT", "ATE") representing the type of causal estimand}

\item{reference_trt}{reference treatment group for the ATT effect}

\item{...}{Other parameters that can be passed to BART functions}
}
\value{
If prior_c_function include a grid specifications for the confounding functions, the output will be a list with 1) the drawn confounding function 2) w-1 causal estimand elements for ATT effect and w*(w-1)/2 causal estimand elements for ATE effect for each combination of the confounding functions. Otherwise, the output will be a data frame containing the estimation, standard error, lower and upper 95\% CI for the causal estimand in terms of RD.
}
\description{
Flexible Monte Carlo sensitivity analysis for unmeasured confounding
}
\examples{
\donttest{
lp_w_all <-
 c(".4*x1 + .1*x2  - 1.1*x4 + 1.1*x5",    # w = 1
   ".2 * x1 + .2 * x2  - 1.2 * x4 - 1.3 * x5")  # w = 2
nlp_w_all <-
 c("-.5*x1*x4  - .1*x2*x5", # w = 1
   "-.3*x1*x4 + .2*x2*x5")# w = 2
lp_y_all <- rep(".2*x1 + .3*x2 - .1*x3 - 1.1*x4 - 1.2*x5", 3)
nlp_y_all <- rep(".7*x1*x1  - .1*x2*x3", 3)
X_all <- c(
 "rnorm(100, 0, 0.5)",# x1
 "rbeta(100, 2, .4)",   # x2
 "runif(100, 0, 0.5)",# x3
 "rweibull(100,1,2)",  # x4
 "rbinom(100, 1, .4)"# x5
)
set.seed(1111)
data <- data_sim(
 sample_size = 100,
 n_trt = 3,
 X = X_all,
 lp_y = lp_y_all,
 nlp_y  = nlp_y_all,
 align = FALSE,
 lp_w = lp_w_all,
 nlp_w = nlp_w_all,
 tau = c(0.5,-0.5,0.5),
 delta = c(0.5,0.5),
 psi = 2
)
c_grid <- c(
 "runif(-0.6, 0)",# c(1,2)
 "runif(0, 0.6)",# c(2,1)
 "runif(-0.6, 0)", # c(2,3)
 "seq(-0.6, 0, by = 0.3)", # c(1,3)
 "seq(0, 0.6, by = 0.3)", # c(3,1)
 "runif(0, 0.6)" # c(3,2)
)
sensitivity_analysis_parallel_result <-
 sa(
   M1 = 1,
   x = data$covariates,
   y = data$y,
   w = data$w,
   prior_c_function = c_grid,
   nCores = 1,
   estimand = "ATE",
 )
 }
}
