% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{newbroom}
\alias{newbroom}
\title{Tidy Tables for htest objects}
\usage{
newbroom(x)
}
\arguments{
\item{x}{An `htest` object, such as those created by [stats::cor.test()],
[stats::t.test()], [stats::wilcox.test()], [stats::chisq.test()], etc.}
}
\value{
An object of class "tibble".
}
\description{
Produces tidy tibbles of results from htest objects.  
This is a vastly reduced version of the tidy.htest function from
package broom
}
\examples{

chit <- chisq.test(xtabs(Freq ~ Sex + Class, data = as.data.frame(Titanic)))
CGPfunctions:::newbroom(chit)
}
\seealso{
[stats::t.test()], [stats::oneway.test()]
  [stats::wilcox.test()], [stats::chisq.test()]
}
\keyword{internal}
