#' CGPfunctions: A package of miscellaneous functions for teaching statistics.
#'
#' A package that includes miscellaneous functions useful for teaching statistics as well as actually practicing the art. They typically are not new methods but rather wrappers around either base R or other packages.
#'
#' @section Functions included:
#' \itemize{
#'   \item \code{\link{newggslopegraph}} creates a "slopegraph" as conceptualized by Edward Tufte.
#'   \item \code{\link{Plot2WayANOVA}} which as the name implies conducts a 2 way ANOVA and plots the results using `ggplot2`
#'   \item \code{\link{PlotXTabs2}} which wraps around ggplot2 to provide Bivariate bar charts for categorical and ordinal data.
#'   \item \code{\link{chaid_table}} provides tabular summary of CHAID partykit object.
#'   \item \code{\link{cross2_var_vectors}} helper function to cross a vector of variables.
#'   \item \code{\link{PlotXTabs}} Plots cross tabulated variables using `ggplot2`
#'   \item \code{\link{Mode}} which finds the modal value in a vector of data
#'   \item \code{\link{SeeDist}} which wraps around ggplot2 to provide visualizations of univariate data.
#'   \item \code{\link{OurConf}} which wraps around ggplot2 to provide visualizations of sampling confidence intervals.
#' }
#'
#' @docType package
#' @name CGPfunctions
NULL
