% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neweta.R
\name{neweta}
\alias{neweta}
\title{Calculates eta squared for an AOV model using the Type II method}
\usage{
neweta(MyAOV)
}
\arguments{
\item{MyAOV}{a valid aov object such as those produced by
\code{aov(dv~iv1*iv2)}}
}
\value{
Returns a tibble containing the AOV output similar to
\code{summary(aov(MyAOV))} but with eta squared computed and appended as an
additional column
}
\description{
Takes an aov object and returns a standard AOV table with eta squared
computed
}
\details{
There are three ways to compute eta squared this function only uses Type II
}
\examples{

neweta(aov(mpg~am*cyl, mtcars))
}
\references{
neweta function is a shortened and simplified verion of Dani
Navarro's \code{\link[lsr]{etaSquared}}
}
\seealso{
\code{\link{Plot2WayANOVA}}
}
\author{
Chuck Powell
}
