% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoE.R
\name{designRandom}
\alias{designRandom}
\title{Random Design}
\usage{
designRandom(x = NULL, cF, size, control = list())
}
\arguments{
\item{x}{Optional list of user specified solutions to be added to the design, defaults to NULL}

\item{size}{size of the design}

\item{control}{not used}

\item{cf}{Creation function, creates random new individuals}
}
\value{
Returns list with experimental design without duplicates
}
\description{
Create a random initial population or experimental design, given a specifed creation function,
as well as a optional set of user-specified design members and a maximum design size.
Also removes duplicates from the design/population.
}
\examples{
# Create a design of 10 permutations, each with 5 elements
design <- designRandom(NULL,function()sample(5),10)
# Create a design of 20 real valued 2d vectors
design <- designRandom(NULL,function()runif(2),20)
}
\seealso{
\code{\link{optimRS}}, \code{\link{designMaxMinDist}}
}
\keyword{internal}
