% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationAdjacency}
\alias{distancePermutationAdjacency}
\title{Adjacency Distance for Permutations}
\usage{
distancePermutationAdjacency(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
Bi-directional adjacency distance for permutations, depending on how often two elements are neighbours in both permutations x and y.
}
\examples{
x <- 1:5
y <- 5:1
distancePermutationAdjacency(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationAdjacency)
}
\references{
Sevaux, Marc, and Kenneth Soerensen. "Permutation distance measures for memetic algorithms with population management." Proceedings of 6th Metaheuristics International Conference (MIC'05). 2005.

Reeves, Colin R. "Landscapes, operators and heuristic search." Annals of Operations Research 86 (1999): 473-490.
}

