% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{cdmName}
\alias{cdmName}
\alias{cdm_name}
\title{Get the CDM name}
\usage{
cdmName(cdm)

cdm_name(cdm)
}
\arguments{
\item{cdm}{A cdm object}
}
\value{
The name of the CDM as a character string
}
\description{
Extract the CDM name attribute from a cdm_reference object
}
\examples{
\dontrun{
library(CDMConnector)
con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())
cdm <- cdm_from_con(con, "eunomia", "main")
cdmName(cdm)
#> [1] "eunomia"

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
