% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{cdm_from_con}
\alias{cdm_from_con}
\alias{cdmFromCon}
\title{Create a CDM reference object from a database connection}
\usage{
cdm_from_con(
  con,
  cdm_schema,
  write_schema,
  cohort_tables = NULL,
  cdm_version = "5.3",
  cdm_name = NULL,
  achilles_schema = NULL,
  .soft_validation = FALSE
)

cdmFromCon(
  con,
  cdmSchema,
  writeSchema,
  cohortTables = NULL,
  cdmVersion = "5.3",
  cdmName = NULL,
  achillesSchema = NULL,
  .softValidation = FALSE
)
}
\arguments{
\item{con}{A DBI database connection to a database where an OMOP CDM v5.4 or
v5.3 instance is located.}

\item{cdm_schema, cdmSchema}{The schema where the OMOP CDM tables are located. Defaults
to NULL.}

\item{write_schema, writeSchema}{An optional schema in the CDM database that the user has
write access to.}

\item{cohort_tables, cohortTables}{A character vector listing the cohort table names to be
included in the CDM object.}

\item{cdm_version, cdmVersion}{The version of the OMOP CDM: "5.3" (default), "5.4",
"auto". "auto" attempts to automatically determine the cdm version using
heuristics. Cohort tables must be in the write_schema.}

\item{cdm_name, cdmName}{The name of the CDM. If NULL (default) the cdm_source_name
.  field in the CDM_SOURCE table will be used.}

\item{achilles_schema, achillesSchema}{An optional schema in the CDM database
that contains achilles tables.}

\item{.soft_validation, .softValidation}{If TRUE fewer validation checks will
be performed.}
}
\value{
A list of dplyr database table references pointing to CDM tables
}
\description{
Create a CDM reference object from a database connection
}
