% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionFramework.R
\name{functionSUB}
\alias{functionSUB}
\title{Build dpCDFs through use of a noisy tree with bin merging.}
\usage{
functionSUB(eps, cdfstep, data, range, gran, K = 2, ...)
}
\arguments{
\item{eps}{Epsilon value for Differential privacy control}

\item{cdfstep}{The step sized used in outputting the approximate CDF; 
the values output are [min, min + cdfstep], [min, min + 2 * cdfstep], etc.}

\item{data}{A vector of the data (single variable to compute CDFs from)}

\item{range}{A vector length 2 containing user-specified min and max to truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] for a list of ages)}

\item{K}{This sets the degree of the underlying tree.}

\item{...}{Optionally add additional parameters.}
}
\value{
A list with 2 vectors: one is the y coordinates of the DP-CDF, the other is the
   abs values of the anlytically expected bounds for a similarly-constructed
   DP-CDF, at 95 percent probability made without merging.
}
\description{
The function first creates a k-ary aggregate tree on the histogram bins.
 It then utilizes epsilon1 in order to privately discover the best way to
 prune sub-trees in order to reduce the L2 error due to the noise addition.
 It then prunes the sub-trees of the original tree, and outputs it by utilizing epsilon2.
 Finally, it utilizes this output to compute and release the private CDF.
}
\examples{
functionSUB(eps = .01, cdfstep = .1, data = rexp(10000,.4), range= c(1,10), gran = .1, K= 2)
}

