% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doFtest.R
\name{doFtest}
\alias{doFtest}
\title{Perform F Test}
\usage{
doFtest(DF, p = 0.01, lower.tail = FALSE)
}
\arguments{
\item{DF}{data frame, it must contain a column named 'Concentration' and a column named 'Response'}

\item{p}{p-value}

\item{lower.tail}{default is FALSE}
}
\value{
dataframe, F test result
}
\description{
perform F test to evaluate homoscedasticity.
}
\examples{
Concentration <- rep(c(10, 50, 100, 500), each = 3)
Response <- c(133, 156, 177, 1300, 1450, 1600, 4000, 3881, 3700, 140000, 134000, 140000)
DF <- cbind.data.frame(Concentration, Response)
result <- doFtest(DF, p = 0.01)
}
\author{
Yonghui Dong
}
