% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pies.R
\name{create_Pies}
\alias{create_Pies}
\title{Create Pies}
\usage{
create_Pies(
  Input,
  NamesIn = NULL,
  Classes = NULL,
  cols = c("green", "red"),
  Size = 50,
  SizeVar = NULL,
  GridKm = NULL,
  Other = 0,
  Othercol = "grey"
)
}
\arguments{
\item{Input}{input dataframe.}

\item{NamesIn}{character vector of length 4 specifying the column names of Latitude, Longitude,
Class and value fields in the \code{Input}.

Names must be given in that order, e.g.:

\code{NamesIn=c('Latitude','Longitude','Class','Value')}.}

\item{Classes}{character, optional vector of classes to be displayed. If this excludes classes that are in the \code{Input},
those excluded classes will be pooled in a 'Other' class.}

\item{cols}{character, vector of two or more color names to colorize pie pieces.}

\item{Size}{numeric, value controlling the size of pies.}

\item{SizeVar}{numeric, optional, name of the field in the \code{Input} that should be used to scale the area of pies.
Must be unique to locations in the input.}

\item{GridKm}{numeric, optional, cell size of the grid in kilometers. If provided, locations are pooled by grid
cell and values are summed for each class.}

\item{Other}{numeric, optional, percentage threshold below which classes are pooled in a 'Other' class.}

\item{Othercol}{character, optional, color of the pie piece for the 'Other' class.}
}
\value{
Spatial object in your environment, ready to be plotted.
}
\description{
Generates pie charts that can be overlaid on maps. The \code{Input} data must be a dataframe with, at least,
columns for latitude, longitude, class and value. For each location, a pie is created with pieces for each class,
and the size of each piece depends on the proportion of each class (the value of each class divided by the sum of values).
Optionally, the area of each pie can be proportional to a chosen variable (if that variable is different than the 
value mentioned above, the \code{Input} data must have a fifth column and that variable must be unique to each location).
If the \code{Input} data contains locations that are too close together, the data can be gridded by setting \code{GridKm}.
Once pie charts have been created, the function \link{add_PieLegend} may be used to add a legend to the figure.
}
\examples{
 
# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#23-create-pies
  
#Pies of constant size, all classes displayed:
#Create pies
MyPies=create_Pies(Input=PieData,NamesIn=c("Lat","Lon","Sp","N"),Size=50)
#Plot Pies
plot(st_geometry(MyPies),col=MyPies$col)
#Add Pies legend
add_PieLegend(Pies=MyPies,PosX=-0.1,PosY=-1,Boxexp=c(0.5,0.45,0.12,0.45),
             PieTitle="Species")



}
\seealso{
\code{\link{add_PieLegend}}, \code{\link{PieData}}, \code{\link{PieData2}}.
}
