% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bss.R
\name{bss}
\alias{bss}
\title{Best subset feature selection}
\usage{
bss(
  predictors,
  response,
  method = "rf",
  metric = ifelse(is.factor(response), "Accuracy", "RMSE"),
  maximize = ifelse(metric == "RMSE", FALSE, TRUE),
  globalval = FALSE,
  trControl = caret::trainControl(),
  tuneLength = 3,
  tuneGrid = NULL,
  seed = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{predictors}{see \code{\link{train}}}

\item{response}{see \code{\link{train}}}

\item{method}{see \code{\link{train}}}

\item{metric}{see \code{\link{train}}}

\item{maximize}{see \code{\link{train}}}

\item{globalval}{Logical. Should models be evaluated based on 'global' performance? See \code{\link{global_validation}}}

\item{trControl}{see \code{\link{train}}}

\item{tuneLength}{see \code{\link{train}}}

\item{tuneGrid}{see \code{\link{train}}}

\item{seed}{A random number}

\item{verbose}{Logical. Should information about the progress be printed?}

\item{...}{arguments passed to the classification or regression routine
(such as randomForest).}
}
\value{
A list of class train. Beside of the usual train content
the object contains the vector "selectedvars" and "selectedvars_perf"
that give the best variables selected as well as their corresponding
performance. It also contains "perf_all" that gives the performance of all model runs.
}
\description{
Evaluate all combinations of predictors during model training
}
\details{
bss is an alternative to \code{\link{ffs}} and ideal if the training
set is small. Models are iteratively fitted using all different combinations
of predictor variables. Hence, 2^X models are calculated. Don't try running bss
on very large datasets because the computation time is much higher compared to
\code{\link{ffs}}.

The internal cross validation can be run in parallel. See information
on parallel processing of carets train functions for details.
}
\note{
This variable selection is particularly suitable for spatial
cross validations where variable selection
MUST be based on the performance of the model for predicting new spatial units.
Note that bss is very slow since all combinations of variables are tested.
A more time efficient alternative is the forward feature selection (\code{\link{ffs}}).
}
\examples{
\dontrun{
data(iris)
bssmodel <- bss(iris[,1:4],iris$Species)
bssmodel$perf_all
plot(bssmodel)
}
}
\seealso{
\code{\link{train}},\code{\link{ffs}},
\code{\link{trainControl}},\code{\link{CreateSpacetimeFolds}},
\code{\link{nndm}}
}
\author{
Hanna Meyer
}
