% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clusterforest}
\alias{clusterforest}
\title{Clustering the classification trees in a forest}
\usage{
clusterforest(simmatrix, trees, fulldata, treedata, Y, A = NULL, fromclus,
  toclus)
}
\arguments{
\item{simmatrix}{Similarity matrix containing the similarities between all pairs of trees in the forest}

\item{trees}{A list with all trees that should be clustered, each tree should be stored as party object}

\item{fulldata}{The original full dataset}

\item{treedata}{A list with data sets on which the trees in the forest were based (i.e., one data set for each tree)}

\item{Y}{A vector with the name of the outcome variable on which each tree in the forest was based}

\item{A}{by default, in case of a treatment regime, it should denote the name of the variable that indicates the assigned treatment alternative in the data set}

\item{fromclus}{The lowest number of clusters for which the clustering should be done}

\item{toclus}{The highest number of clusters for which the clustering should be done}
}
\value{
\item{medoids}{the position of the medoid trees in the forest (i.e., which element of the list of trees)}
\item{mds}{the medoid trees}
\item{clusters}{The cluster number to which each tree is assigned}
\item{silplot}{Plot of the average silhouette width for each solution}
\item{withinplot}{Plot of the within cluster similarity for each solution}
\item{agreementplot}{Plot of the agreement between the assignments of the forest as a whole, and those based on the medoids for each solution}
}
\description{
Function to cluster classification trees in a forest using Partitioning Around Medoids (PAM, Kaufman & Rousseeuw, 2009).
}
\examples{
require(MASS)

#Create a forest by drawing 10 bootstrap samples and growing a classification tree on each one
forest <- growforest(data = Pima.tr, X = c("npreg", "glu",  "bp",  "skin",  "bmi", "ped", "age"), 
Y = "type", ntrees = 10)

#Calculate similarities between all pairs of trees in the forest 
simmatrix <- similarities(fulldata = Pima.tr, treedata = forest[[2]], Y = rep("type", 10),
X = c("npreg", "glu", "bp", "skin", "bmi", "ped", "age"), trees=forest[[1]], m = 1, weight = 0)

#Cluster the trees in the forest.
cforest<- clusterforest(simmatrix = simmatrix, trees = forest[[1]], 
fulldata= Pima.tr, treedata=forest[[2]], Y=rep("type", 10), fromclus=1, toclus=5)

#Inspect medoids of five cluster solution
cforest$mds[[5]]
}
\references{
\cite{Kaufman, L., & Rousseeuw, P. J. (2009). Finding groups in data: an introduction to cluster analysis (Vol. 344). John Wiley & Sons.}

\cite{Ball, G. H., & Hall, D. J. (1965). ISODATA, a novel method of data analysis and pattern classification. Stanford research inst Menlo Park CA.}

\cite{Kaufman, L., & Rousseeuw, P. J. (2009). Finding groups in data: an introduction to cluster analysis (Vol. 344). John Wiley & Sons.}
}
