% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMCIs.R
\name{plot.BranchGLMCIs}
\alias{plot.BranchGLMCIs}
\title{Plot Method for BranchGLMCIs Objects}
\usage{
\method{plot}{BranchGLMCIs}(x, which = "all", mary = 5, ...)
}
\arguments{
\item{x}{a \code{BranchGLMCIs} object.}

\item{which}{which intervals to plot, can use indices or names of desired variables.}

\item{mary}{value used to determine how large to make margin of y-axis. If variable 
names are cut-off, consider increasing this from the default value of 5.}

\item{...}{further arguments passed to \link{plotCI}.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Plot Method for BranchGLMCIs Objects
}
\examples{
Data <- iris
### Fitting linear regression model
mymodel <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

### Getting confidence intervals
CIs <- confint(mymodel, level = 0.95)
CIs

### Plotting CIs
plot(CIs, mary = 7, cex.y = 0.9)

}
