% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1102-PLS.R
\name{pls.cv}
\alias{pls.cv}
\title{The Cross-Validation of Classification and Regression models using Partial Least Squares}
\usage{
pls.cv(xtr, ytr, cv.fold = 5, maxcomp = NULL)
}
\arguments{
\item{xtr}{A data frame or a matrix of predictors.}

\item{ytr}{A response vector. If a factor, classification is assumed, otherwise 
regression is assumed.}

\item{cv.fold}{The fold, the defalut is 5.}

\item{maxcomp}{Maximum number of components included within the models, 
if not specified, default is the variable (column) numbers in x.}
}
\value{
the retrun a list containing four components:
\itemize{
\item \code{plspred} - the predicted values of the input data based on cross-validation
\item \code{Error} - error for all samples
\item \code{RMSECV} - Root Mean Square Error for cross-validation
\item \code{Q2} - R2 for cross-validation
}
}
\description{
The Cross-Validation of Classification and Regression models using Partial Least Squares
}
\details{
This function performs k-fold cross validation for partial least squares regression and 
classification.
}
\examples{
training = read.csv(system.file('sysdata/training2.csv', package = 'BioMedR'), header = TRUE)
y = training[, 1]
x = training[, -1]
pls.tr <- pls.cv(x, y)

}
\seealso{
See \code{\link{rf.cv}} for the Cross-Validation of Classification and 
Regression models using Random Forest
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\keyword{pls.cv}
