% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1003-clusterJarvis-Patrick.R
\name{NNeighbors}
\alias{NNeighbors}
\title{Nearest Neighbors}
\usage{
NNeighbors(x, numNbrs = NULL, cutoff = NULL, ...)
}
\arguments{
\item{x}{Either an \code{FPset} or an \code{APset}.}

\item{numNbrs}{Number of neighbors to find for each item. If not enough neighbors can be found the 
matrix will be padded with NA.}

\item{cutoff}{The minimum similarity value an item must have to another item in order to be included 
in that items neighbor list. This parameter takes precedence over \code{numNbrs}. This 
parameter allows to obtain tighter clustering results.}

\item{...}{These parameters will be passed into the distance function used}
}
\value{
The return value is a list with the following components:
\itemize{
\item \code{indexes} - index values of nearest neighbors, for each item. If \code{cutoff} is
used, this will be a list of lists, otherwise it will be a matrix
\item \code{names} - The names of each item in the set, as returned by cid
\item \code{similarities} - The similarity values of each neighbor to the item for that row. 
This will also be either a list of lists or a matrix, depending on whether or not
\code{cutoff} was used. Each similarity values corresponds to the id number in the 
same position in the indexes entry
}
}
\description{
Nearest Neighbors
}
\details{
Computes the nearest neighbors of descriptors in an FPset or APset object for use with the 
\code{\link{jarvisPatrick}} clustering function. Only one of \code{numNbrs} or \code{cutoff} 
should be given, \code{cutoff} will take precedence if both are given. If \code{numNbrs} is 
given, then that many neighbors will be returned for each item in the set. If \code{cutoff} 
is given, then, for each item X, every neighbor that has a similarity value greater than or 
equal to  the cutoff will be returned in the neighbor list for X.
}
\examples{
data(sdfbcl)
apbcl = convSDFtoAP(sdfbcl)
nnm = NNeighbors(apbcl, cutoff = 0.5)

}
\seealso{
See \code{\link{clusterJP}} for Jarvis-Patrick Clustering
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\keyword{NNeighbors}
\keyword{Neighbors}
\keyword{nearest}
