#!/usr/bin/env python
import os
import lagrange
data = """\
### begin data
{'area_adjacency': [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
 'area_dispersal': [[[1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0]]],
 'area_labels': ['A', 'B', 'C', 'D'],
 'base_rates': '__estimate__',
 'dispersal_durations': [1000.0],
 'dm_symmetric_entry': True,
 'excluded_ranges': [],
 'lagrange_version': '20120508',
 'max_range_size': 4,
 'model_name': 'Lonicera_M0',
 'newick_trees': [{'included': '__all__',
                   'name': 'Tree0',
                   'newick': '(Heptacodium_miconioides:68.8490955697, ((Triosteum_sinuatum:43.4831715114, (((Triosteum_pinnatifidum:31.3612476766, Triosteum_sp:31.3612476766)N4:7.59737861402, Triosteum_himalayanum:38.9586262906)N6:0.736488924805, ((Triosteum_angustifolium:2.7613094522, Triosteum_aurantiacum:2.7613094522)N9:1.95594027201, Triosteum_perfoliatum:4.71724972421)N11:34.9778654912)N12:3.78805629595)N13:10.9832986604, ((((Lonicera_albiflora:8.69499973376, (Lonicera_sempervirens:4.45552188172, (((Lonicera_dioica:1.08849725317, Lonicera_arizonica:1.08849725317)N18:1.09421088576, Lonicera_flava:2.18270813894)N20:1.5361730782, (Lonicera_hirsuta:1.20560301186, Lonicera_interrupta:1.20560301186)N23:2.51327820527)N24:0.736640664587)N25:4.23947785204)N26:0.502323202773, (((Lonicera_pilosa:5.93629662124, Lonicera_hispidula:5.93629662124)N29:2.03278647237, (Lonicera_ciliosa:7.78324311756, ((Lonicera_etrusca:4.16362573218, Lonicera_caprifolium:4.16362573218)N33:0.665600813571, Lonicera_implexa:4.82922654575)N35:2.95401657182)N36:0.185839976044)N37:0.895738172974, ((Lonicera_periclymenum:6.12698663245, (Lonicera_tragophylla:4.76682099874, Lonicera_carnosifolia:4.76682099874)N41:1.36016563371)N42:0.753027821063, Lonicera_subspicata:6.88001445351)N44:1.98480681307)N45:0.332501669956)N46:18.9210226369, (((Lonicera_vesicaria:18.5904160402, (Lonicera_iberica:5.57236902984, Lonicera_ferdinandi:5.57236902984)N50:13.0180470103)N51:5.95768881713, (((((((Lonicera_quinquelocularis:0.529034344875, Lonicera_cyanocarpa:0.529034344875)N54:12.794121301, ((Lonicera_lanceolata:2.14634831909, Lonicera_trichosantha:2.14634831909)N57:9.25617654396, ((Lonicera_demissa:9.29578407389, ((Lonicera_chrysantha:5.43127653156, (((Lonicera_koehneana:0.584227042191, Lonicera_heteroloba:0.584227042191)N62:0.033207772417, Lonicera_xylosteum:0.617434814608)N64:2.88078277916, Lonicera_floribunda:3.49821759377)N66:1.93305893779)N67:1.7384094425, (Lonicera_deflexicalyx:4.12437827489, Lonicera_steveniana:4.12437827489)N70:3.04530769917)N71:2.12609809983)N72:0.805515238499, (Lonicera_maackii:4.79802122411, Lonicera_subsessilis:4.79802122411)N75:5.30327808828)N76:1.30122555067)N77:1.92063078281)N78:1.23933339634, (((Lonicera_morrowii:4.64632310004, (Lonicera_tatarica:4.22912011622, Lonicera_sovetkinae:4.22912011622)N82:0.417202983816)N83:3.89954643326, Lonicera_korolkovii:8.5458695333)N85:2.11607385748, Lonicera_ruprechtiana:10.6619433908)N87:3.90054565142)N88:3.26677021198, (Lonicera_oblongifolia:14.0393764173, ((Lonicera_maximowiczii:5.68136786461, Lonicera_modesta:5.68136786461)N92:4.97050247659, ((Lonicera_orientalis:7.79846050428, Lonicera_nigra:7.79846050428)N95:1.21375588205, (Lonicera_graebneri:3.79403573787, Lonicera_nervosa:3.79403573787)N98:5.21818064847)N99:1.63965395486)N100:3.38750607609)N101:3.78988283689)N102:3.70809681474, (Lonicera_gynochlamydea:14.3206562722, ((Lonicera_spinosa:8.53777634564, (Lonicera_syringantha:3.20333932461, Lonicera_rupicola:3.20333932461)N107:5.33443702103)N108:1.0281020397, ((Lonicera_tomemtella:1.70601591255, (Lonicera_myrtilloides:1.12796998642, Lonicera_myrtillus:1.12796998642)N112:0.57804592612)N113:4.63976199596, Lonicera_serreana:6.3457779085)N115:3.22010047684)N116:4.75477788685)N117:7.21669979673)N118:0.241839065433, ((Lonicera_acuminata:10.58593559, (Lonicera_giraldii:5.85466580727, (Lonicera_henryi:3.21490103413, Lonicera_japonica:3.21490103413)N123:2.63976477314)N124:4.7312697827)N125:5.0347593412, Lonicera_confusa:15.6206949312)N127:6.15850020319)N128:1.89140209777, (Lonicera_pyrenaica:20.936923046, ((Lonicera_pileata:1.43719829289, Lonicera_nitida:1.43719829289)N132:15.1280268118, ((Lonicera_involucrata:4.8097517631, Lonicera_ledebourii:4.8097517631)N135:7.98443854667, (Lonicera_hemsleyana:10.394941849, Lonicera_alpigena:10.394941849)N138:2.39924846074)N139:3.7710347949)N140:4.37169794134)N141:2.73367418613)N142:0.877507625163)N143:2.69195989164, ((((Lonicera_tangutica:6.26682157515, (Lonicera_oresbia:4.47246871404, Lonicera_inconspicua:4.47246871404)N147:1.79435286111)N148:6.28504881449, (Lonicera_obovata:11.9380306219, Lonicera_microphylla:11.9380306219)N151:0.613839767752)N152:9.63388775532, (Lonicera_gracilipes:12.7253370209, Lonicera_caerulea:12.7253370209)N155:9.46042112403)N156:1.14188222793, ((Lonicera_calcarata:12.9159519683, Lonicera_altmannii:12.9159519683)N159:7.18072184691, ((Lonicera_hispida:10.7593823683, Lonicera_setifera:10.7593823683)N162:3.84933084494, (Lonicera_standishii:0.801371143953, Lonicera_fragrantissima:0.801371143953)N165:13.8073420693)N166:5.48796060192)N167:3.2309665577)N168:3.91242437605)N169:0.878280824477)N170:19.5881595403, (((Symphoricarpos_orbiculatus:7.76280748845, Symphoricarpos_hesperius:7.76280748845)N173:2.43940308846, (Symphoricarpos_occidentalis:5.30056297631, Symphoricarpos_albus:5.30056297631)N176:4.9016476006)N177:24.3089008956, (Leycesteria_crocothyrsos:18.3437740288, Leycesteria_formosa:18.3437740288)N180:16.1673374437)N181:13.1953936412)N182:6.759965058)N183:14.3826253979)N184;',
                   'root_age': 68.849095569699998}],
 'ranges': [(),
            (0,),
            (0, 1),
            (0, 1, 2),
            (0, 1, 2, 3),
            (0, 1, 3),
            (0, 2),
            (0, 2, 3),
            (0, 3),
            (1,),
            (1, 2),
            (1, 2, 3),
            (1, 3),
            (2,),
            (2, 3),
            (3,)],
 'taxa': ['Heptacodium_miconioides',
          'Leycesteria_crocothyrsos',
          'Leycesteria_formosa',
          'Lonicera_acuminata',
          'Lonicera_albiflora',
          'Lonicera_alpigena',
          'Lonicera_altmannii',
          'Lonicera_arizonica',
          'Lonicera_caerulea',
          'Lonicera_calcarata',
          'Lonicera_caprifolium',
          'Lonicera_carnosifolia',
          'Lonicera_chrysantha',
          'Lonicera_ciliosa',
          'Lonicera_confusa',
          'Lonicera_cyanocarpa',
          'Lonicera_deflexicalyx',
          'Lonicera_demissa',
          'Lonicera_dioica',
          'Lonicera_etrusca',
          'Lonicera_ferdinandi',
          'Lonicera_flava',
          'Lonicera_floribunda',
          'Lonicera_fragrantissima',
          'Lonicera_giraldii',
          'Lonicera_gracilipes',
          'Lonicera_graebneri',
          'Lonicera_gynochlamydea',
          'Lonicera_hemsleyana',
          'Lonicera_henryi',
          'Lonicera_heteroloba',
          'Lonicera_hirsuta',
          'Lonicera_hispida',
          'Lonicera_hispidula',
          'Lonicera_iberica',
          'Lonicera_implexa',
          'Lonicera_inconspicua',
          'Lonicera_interrupta',
          'Lonicera_involucrata',
          'Lonicera_japonica',
          'Lonicera_koehneana',
          'Lonicera_korolkovii',
          'Lonicera_lanceolata',
          'Lonicera_ledebourii',
          'Lonicera_maackii',
          'Lonicera_maximowiczii',
          'Lonicera_microphylla',
          'Lonicera_modesta',
          'Lonicera_morrowii',
          'Lonicera_myrtilloides',
          'Lonicera_myrtillus',
          'Lonicera_nervosa',
          'Lonicera_nigra',
          'Lonicera_nitida',
          'Lonicera_oblongifolia',
          'Lonicera_obovata',
          'Lonicera_oresbia',
          'Lonicera_orientalis',
          'Lonicera_periclymenum',
          'Lonicera_pileata',
          'Lonicera_pilosa',
          'Lonicera_pyrenaica',
          'Lonicera_quinquelocularis',
          'Lonicera_rupicola',
          'Lonicera_ruprechtiana',
          'Lonicera_sempervirens',
          'Lonicera_serreana',
          'Lonicera_setifera',
          'Lonicera_sovetkinae',
          'Lonicera_spinosa',
          'Lonicera_standishii',
          'Lonicera_steveniana',
          'Lonicera_subsessilis',
          'Lonicera_subspicata',
          'Lonicera_syringantha',
          'Lonicera_tangutica',
          'Lonicera_tatarica',
          'Lonicera_tomemtella',
          'Lonicera_tragophylla',
          'Lonicera_trichosantha',
          'Lonicera_vesicaria',
          'Lonicera_xylosteum',
          'Symphoricarpos_albus',
          'Symphoricarpos_hesperius',
          'Symphoricarpos_occidentalis',
          'Symphoricarpos_orbiculatus',
          'Triosteum_angustifolium',
          'Triosteum_aurantiacum',
          'Triosteum_himalayanum',
          'Triosteum_perfoliatum',
          'Triosteum_pinnatifidum',
          'Triosteum_sinuatum',
          'Triosteum_sp'],
 'taxon_range_data': {'Heptacodium_miconioides': (3,),
                      'Leycesteria_crocothyrsos': (3,),
                      'Leycesteria_formosa': (3,),
                      'Lonicera_acuminata': (3,),
                      'Lonicera_albiflora': (0,),
                      'Lonicera_alpigena': (2,),
                      'Lonicera_altmannii': (3,),
                      'Lonicera_arizonica': (0,),
                      'Lonicera_caerulea': (0, 1, 2, 3),
                      'Lonicera_calcarata': (3,),
                      'Lonicera_caprifolium': (2,),
                      'Lonicera_carnosifolia': (3,),
                      'Lonicera_chrysantha': (3,),
                      'Lonicera_ciliosa': (0,),
                      'Lonicera_confusa': (3,),
                      'Lonicera_cyanocarpa': (3,),
                      'Lonicera_deflexicalyx': (3,),
                      'Lonicera_demissa': (3,),
                      'Lonicera_dioica': (1,),
                      'Lonicera_etrusca': (2,),
                      'Lonicera_ferdinandi': (3,),
                      'Lonicera_flava': (1,),
                      'Lonicera_floribunda': (3,),
                      'Lonicera_fragrantissima': (3,),
                      'Lonicera_giraldii': (3,),
                      'Lonicera_gracilipes': (3,),
                      'Lonicera_graebneri': (3,),
                      'Lonicera_gynochlamydea': (3,),
                      'Lonicera_hemsleyana': (3,),
                      'Lonicera_henryi': (3,),
                      'Lonicera_heteroloba': (3,),
                      'Lonicera_hirsuta': (1,),
                      'Lonicera_hispida': (3,),
                      'Lonicera_hispidula': (0,),
                      'Lonicera_iberica': (3,),
                      'Lonicera_implexa': (2,),
                      'Lonicera_inconspicua': (3,),
                      'Lonicera_interrupta': (0,),
                      'Lonicera_involucrata': (0,),
                      'Lonicera_japonica': (3,),
                      'Lonicera_koehneana': (3,),
                      'Lonicera_korolkovii': (3,),
                      'Lonicera_lanceolata': (3,),
                      'Lonicera_ledebourii': (0,),
                      'Lonicera_maackii': (3,),
                      'Lonicera_maximowiczii': (3,),
                      'Lonicera_microphylla': (3,),
                      'Lonicera_modesta': (3,),
                      'Lonicera_morrowii': (3,),
                      'Lonicera_myrtilloides': (3,),
                      'Lonicera_myrtillus': (3,),
                      'Lonicera_nervosa': (3,),
                      'Lonicera_nigra': (2,),
                      'Lonicera_nitida': (3,),
                      'Lonicera_oblongifolia': (1,),
                      'Lonicera_obovata': (3,),
                      'Lonicera_oresbia': (3,),
                      'Lonicera_orientalis': (3,),
                      'Lonicera_periclymenum': (2,),
                      'Lonicera_pileata': (3,),
                      'Lonicera_pilosa': (0,),
                      'Lonicera_pyrenaica': (2,),
                      'Lonicera_quinquelocularis': (3,),
                      'Lonicera_rupicola': (3,),
                      'Lonicera_ruprechtiana': (3,),
                      'Lonicera_sempervirens': (1,),
                      'Lonicera_serreana': (3,),
                      'Lonicera_setifera': (3,),
                      'Lonicera_sovetkinae': (2, 3),
                      'Lonicera_spinosa': (3,),
                      'Lonicera_standishii': (3,),
                      'Lonicera_steveniana': (2,),
                      'Lonicera_subsessilis': (3,),
                      'Lonicera_subspicata': (0,),
                      'Lonicera_syringantha': (3,),
                      'Lonicera_tangutica': (3,),
                      'Lonicera_tatarica': (2, 3),
                      'Lonicera_tomemtella': (3,),
                      'Lonicera_tragophylla': (3,),
                      'Lonicera_trichosantha': (3,),
                      'Lonicera_vesicaria': (3,),
                      'Lonicera_xylosteum': (2, 3),
                      'Symphoricarpos_albus': (0, 1),
                      'Symphoricarpos_hesperius': (0,),
                      'Symphoricarpos_occidentalis': (0, 1),
                      'Symphoricarpos_orbiculatus': (1,),
                      'Triosteum_angustifolium': (1,),
                      'Triosteum_aurantiacum': (1,),
                      'Triosteum_himalayanum': (3,),
                      'Triosteum_perfoliatum': (1,),
                      'Triosteum_pinnatifidum': (3,),
                      'Triosteum_sinuatum': (3,),
                      'Triosteum_sp': (3,)}}
### end data
"""

i = 0
while 1:
    if not i:
        outfname = "Lonicera_M0.results.txt"
    else:
        outfname = "Lonicera_M0.results-"+str(i)+".txt"
    if not os.path.exists(outfname): break
    i += 1
outfile = open(outfname, "w")
lagrange.output.log(lagrange.msg, outfile, tee=True)
model, tree, data, nodelabels, base_rates = lagrange.input.eval_decmodel(data)
lagrange.output.ascii_tree(outfile, tree, model, data, tee=True)
if base_rates != "__estimate__":
    d, e = base_rates
else:
    d, e = lagrange.output.optimize_dispersal_extinction(outfile, tree, model, tee=True)
if nodelabels:
    if nodelabels == "__all__":
        nodelabels = None
    lagrange.output.ancsplits(outfile, tree, model, d, e, nodelabels=nodelabels, tee=True)
