% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_Bayes.R
\name{BiG_diffuse}
\alias{BiG_diffuse}
\title{BiG with diffuse Inverse Gamma/Uniform prior}
\usage{
BiG_diffuse(r, n_T, n_p1, M = 20000, burnin, prior, ds = 1, dp = 1,
  W = init_W(r), sigma_p10 = 0.5, sigma_p20 = 0.5, mu0 = numeric(G),
  kappa10 = numeric(G), kappa20 = numeric(G), sigma_s0 = rep(1, S),
  a = 0.0202, b = 98.5025)
}
\arguments{
\item{r}{G*S matrix that contains the ranked lists to be aggregated, where G is the total number of items (genes) and S is the total number of ranked lists (studies). \code{NA} indicates non-inclusion of item. Note the matrix needs to be arranged such that all lists that belong to the same platform are next to each other, i.e. the first \code{n_p1} columns are lists from platform 1.}

\item{n_T}{vector of length \code{S} that contains number of top ranked items in each study.}

\item{n_p1}{number of studies belong to platform 1.}

\item{M}{number of MCMC iterations.}

\item{burnin}{number of burn-in iterations.}

\item{prior}{either \code{"IG"} or \code{"uniform"}}

\item{ds, dp}{hyperparameter for the prior distributions of variance parameters for study bias and platform bias respectively. Used only when \code{prior="IG"}.}

\item{W}{G*S matrix that contains initial values for W. Each element of W is the local importance of the corresponding item in the corresponding study, i.e. the latent variable that determines the observed rank.}

\item{sigma_p10, sigma_p20}{initial values for the variance of the platform bias for platform 1 and platform 2 respectively.}

\item{mu0}{vector of length \code{G} that contains initial values for mu. Each element of mu is global importance of the corresponding item, i.e. the latent variable that determines the true rank.}

\item{kappa10, kappa20}{vectors of length \code{G} that contain initial values for kappa1 and kappa2. Each element of kappa1 and kappa2 is the platform bias for the corresponding item in platform 1 and 2 respectively}

\item{sigma_s0}{vector of length \code{S} that contains initial values for the variances of the study bias.}

\item{a, b}{hyperparameters for the prior distributions of standard deviation parameters. Used only when \code{prior="uniform"}.}
}
\description{
BiG implemented with diffuse Inverse Gamma prior or diffuse Uniform prior for the variance/standard deviation parameters.
}
\examples{
set.seed(1234)
sim = sim_lvm(G=25, S=6, n_p1=3, rho=runif(6,min=0.3,max=0.9), p_p1=0.6, p_p2=0.8, 
      lambda=runif(6,min=0.6,max=0.8), n_T=sample(c(5,10,15),6,replace=TRUE))
rank(-BiG_diffuse(r=sim$r, n_T=sim$n_T, n_p1=3, M=100, burnin=50, prior="IG"))
#rank(-BiG_diffuse(r=sim$r, n_T=sim$n_T, n_p1=3, M=100, burnin=50, prior="uniform"))
}
