newspaceskel<-function(n,startspace,currspace,softlimit,hardlimit,posterior,blacklist,
                       MCMCtrace=NULL,mergetype="skeleton") {
  switch(mergetype,
         "dag" = { 
           mdag<-dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=FALSE)
           newadj<-1*(!blacklist&(startspace|mdag))
           toomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(toomanyneib)>0){newadj[,toomanyneib]<-(1*(!blacklist&mdag))[,toomanyneib]}
           toomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(toomanyneib)>0){newadj[,toomanyneib]<-currspace[,toomanyneib]}
         },
         "cpdag" = { 
           mcp<-dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=TRUE)
           newadj<-1*(!blacklist&(startspace|mcp))
           toomanyneib<-which(apply(newadj,2,sum)>softlimit)
           if(length(toomanyneib)>0) {
             mdag<-dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=FALSE)
             newadj[,toomanyneib]<-(1*(!blacklist&(startspace|mdag)))[,toomanyneib]
           }
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-mdag[,tootoomanyneib]}
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-currspace[,tootoomanyneib]}
         },
         "skeleton" = { 
           mskel<-1*(dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=FALSE)|t(dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=FALSE)))
           newadj<-1*(!blacklist&(startspace|mskel))
           toomanyneib<-which(apply(newadj,2,sum)>4)
           if(length(toomanyneib)>0) {
             newadj[,toomanyneib]<-(1*(!blacklist&(startspace|dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=TRUE))))[,toomanyneib]
           }
           toomanyneib<-which(apply(newadj,2,sum)>softlimit)
           if(length(toomanyneib)>0) {
             mdag<-dag.threshold(n,MCMCtrace,pbarrier=posterior,pdag=FALSE)
             newadj[,toomanyneib]<-(1*(!blacklist&(startspace|mdag)))[,toomanyneib]
           }
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-mdag[,tootoomanyneib]}
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-currspace[,tootoomanyneib]}
         }
  )
  return(newadj)
}

newspacemap<-function(n,startspace,currspace,softlimit,hardlimit,blacklist, 
                      maxN,MCMCtrace=NULL,mergetype="skeleton") {
  switch(mergetype,
         "dag" = { 
           maxdag<-MCMCtrace[[maxN]]
           newadj<-1*(!blacklist&(startspace|maxdag))
           toomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(toomanyneib)>0){newadj[,toomanyneib]<-(1*(!blacklist&maxdag))[,toomanyneib]}
           toomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(toomanyneib)>0){newadj[,toomanyneib]<-currspace[,toomanyneib]}
         },
         "cpdag" = { 
           maxcp<-dagadj2cpadj(MCMCtrace[[maxN]])
           newadj<-1*(!blacklist&(startspace|maxcp))
           toomanyneib<-which(apply(newadj,2,sum)>softlimit)
           if(length(toomanyneib)>0) {
             newadj[,toomanyneib]<-(1*(!blacklist&(startspace|MCMCtrace[[maxN]])))[,toomanyneib]
           }
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-MCMCtrace[[maxN]][,tootoomanyneib]}
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-currspace[,tootoomanyneib]}
         },
         "skeleton" = { 
           maxskel<-1*(MCMCtrace[[maxN]]|t(MCMCtrace[[maxN]]))
           newadj<-1*(!blacklist&(startspace|maxskel))
           toomanyneib<-which(apply(newadj,2,sum)>4)
           if(length(toomanyneib)>0) {
             newadj[,toomanyneib]<-(1*(!blacklist&(startspace|dagadj2cpadj(MCMCtrace[[maxN]]))))[,toomanyneib]
           }
           toomanyneib<-which(apply(newadj,2,sum)>softlimit)
           if(length(toomanyneib)>0) {
             newadj[,toomanyneib]<-(1*(!blacklist&(startspace|MCMCtrace[[maxN]])))[,toomanyneib]
           }
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-MCMCtrace[[maxN]][,tootoomanyneib]}
           tootoomanyneib<-which(apply(newadj,2,sum)>hardlimit)
           if(length(tootoomanyneib)>0) {newadj[,tootoomanyneib]<-currspace[,tootoomanyneib]}
         }
  )
  return(newadj)
}

definestartspace<-function(alpha,param,cpdag=FALSE,n,algo="pc") {
  if(is.null(alpha)) { if(n<50) {alpha<-0.4} else {alpha<-max(20/n,0.01)}}
  
  local_type <- param$type
  if(local_type=="dbn"){ # 
    othersliceskel <- definestartspace(alpha,param$otherslices,cpdag=cpdag,n,algo="pc")
    firstsliceskel <- definestartspace(alpha,param$firstslice,cpdag=cpdag,n-param$nsmall,algo="pc")
    startspace <- othersliceskel
    startspace[param$bgnodes,param$bgnodes] <- 1*(startspace[param$bgnodes,param$bgnodes] | firstsliceskel)
  } else { # otherwise use old versions
    
    if(local_type=="bde") {
      if(cpdag){
        pc.skel<-pc(suffStat = list(d1=param$d1,d0=param$d0,data=param$data),
                    indepTest = weightedbinCItest, alpha = alpha, labels = colnames(param$data),
                    verbose = FALSE)
        
      } else {
        pc.skel<-pcalg::skeleton(suffStat = list(d1=param$d1,d0=param$d0,data=param$data),
                                 indepTest = weightedbinCItest, alpha = alpha, labels = colnames(param$data),
                                 verbose = FALSE)
      }
    } else if(local_type=="bdecat") {
      if(cpdag){
        pc.skel<-pc(suffStat = param,
                    indepTest = weightedcatCItest, alpha = alpha, labels = colnames(param$data),
                    verbose = FALSE)
        
      } else {
        pc.skel<-pcalg::skeleton(suffStat = param,
                                 indepTest = weightedcatCItest, alpha = alpha, labels = colnames(param$data),
                                 verbose = FALSE)
      }
    } else if(local_type=="bge") {
      if(is.null(param$weightvector)) {
        cormat<-cor(param$data)
        N<-nrow(param$data)
      } else { N<-sum(param$weightvector)
      cormat<-cov.wt(param$data,wt=param$weightvector,cor=TRUE)$cor}
      if(cpdag){
        pc.skel<-pcalg::pc(suffStat = list(C = cormat, n = N),
                           indepTest = gaussCItest,
                           alpha=alpha,labels=colnames(param$data),skel.method="stable",verbose = FALSE)
      } else {
        pc.skel<-pcalg::skeleton(suffStat = list(C = cormat, n = N),
                                 indepTest = gaussCItest,
                                 alpha=alpha,labels=colnames(param$data),method="stable",verbose = FALSE)
      }
    }
    
    g<-pc.skel@graph
    startspace<-1*(dag2adjacencymatrix(g))
  }
  return(startspace)
}


