% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rows_in_BC}
\alias{rows_in_BC}
\title{Finding BC's with specific rows.}
\usage{
rows_in_BC(bicresult, rows)
}
\arguments{
\item{bicresult}{A \code{Biclust} result. (e.g. The return object from \code{bibit} or \code{bibit2})}

\item{rows}{A vector containing containing the row numbers which should be in the bicluster.}
}
\value{
A matrix containing the biclusters in the columns and the row, column and size dimensions on the rows.
}
\description{
Simple function which scans a \code{Biclust} result and returns which biclusters contain all rows given in the \code{rows} parameter.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
result <- bibit(data,minr=2,minc=2)

rows_in_BC(result,rows=c(21,22,23))

}
}
\author{
Ewoud De Troyer
}

