% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GOF}
\alias{GOF}
\title{Computing Fitness Score of Biclustering Result}
\usage{
GOF(matrix, bicresult, alpha = 1, verbose = FALSE)
}
\arguments{
\item{matrix}{The binary input matrix.}

\item{bicresult}{A \code{Biclust} result. (e.g. The return object from \code{bibit} or \code{bibit2})}

\item{alpha}{Weighting factor between 0 and 1.}

\item{verbose}{Boolean value to show a short summary.}
}
\value{
A list containing the scores.
}
\description{
\emph{EXPERIMENTAL FUNCTION}, still needs tuning. Will eventually be integrated in bibit2 function.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]

result1 <- bibit2(data,minr=5,minc=5,noise=0.2)
result1

fitness <- GOF(matrix=data,bicresult=result1,alpha=0.5)
summary(fitness)
}
}
\author{
Ewoud De Troyer
}

