% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{summary.BeviMed}
\alias{summary.BeviMed}
\title{Summarise a \code{BeviMed} object}
\usage{
\method{summary}{BeviMed}(object, ...)
}
\arguments{
\item{object}{Object of class \code{BeviMed}.}

\item{...}{Arguments passed to \code{summary.BeviMed_m}.}
}
\value{
Object of class \code{BeviMed_summary}.
}
\description{
Create a summary of inference over model gamma = 0 and model gamma = 1 conditional on each mode of inheritance.
}
\details{
Returns a \code{BeviMed_summary} object, which is a list containing elements:
\itemize{
\item `prob_association`: the probability of association under each mode of inheritance,
\item `prior_prob_association`: the prior probability of association for each association model,
\item `gamma0_evidence': the log evidence under model gamma = 0,
\item `models': a list of summaries of model conditional inferences, i.e. objects of class \code{BeviMed_m_summary}. See \code{\link{summary.BeviMed_m}} for more details.
}
}
\seealso{
\code{\link{summary.BeviMed_m}}
}
