/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;

public class GammaSiteModel
extends AbstractModel
implements SiteModel {
    private SubstitutionModel substitutionModel = null;
    private Parameter muParameter;
    private Parameter shapeParameter;
    private Parameter invarParameter;
    private boolean ratesKnown;
    private int categoryCount;
    private double[] categoryRates;
    private double[] categoryProportions;

    public GammaSiteModel(SubstitutionModel substitutionModel) {
        this(substitutionModel, null, null, 0, null);
    }

    public GammaSiteModel(SubstitutionModel substitutionModel, double d, int n) {
        this(substitutionModel, null, new Parameter.Default(d), n, null);
    }

    public GammaSiteModel(SubstitutionModel substitutionModel, double d) {
        this(substitutionModel, null, null, 0, new Parameter.Default(d));
    }

    public GammaSiteModel(SubstitutionModel substitutionModel, double d, int n, double d2) {
        this(substitutionModel, null, new Parameter.Default(d), n, new Parameter.Default(d2));
    }

    public GammaSiteModel(SubstitutionModel substitutionModel, Parameter parameter, Parameter parameter2, int n, Parameter parameter3) {
        super("siteModel");
        this.substitutionModel = substitutionModel;
        this.addModel(substitutionModel);
        this.muParameter = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.shapeParameter = parameter2;
        if (parameter2 != null) {
            this.categoryCount = n;
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(1000.0, 0.001, 1));
        } else {
            this.categoryCount = 1;
        }
        this.invarParameter = parameter3;
        if (parameter3 != null) {
            ++this.categoryCount;
            this.addVariable(parameter3);
            parameter3.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        }
        this.categoryRates = new double[this.categoryCount];
        this.categoryProportions = new double[this.categoryCount];
        this.ratesKnown = false;
    }

    public void setMu(double d) {
        this.muParameter.setParameterValue(0, d);
    }

    public final double getMu() {
        return this.muParameter.getParameterValue(0);
    }

    public void setAlpha(double d) {
        this.shapeParameter.setParameterValue(0, d);
        this.ratesKnown = false;
    }

    public final double getAlpha() {
        return this.shapeParameter.getParameterValue(0);
    }

    public Parameter getMutationRateParameter() {
        return this.muParameter;
    }

    public Parameter getAlphaParameter() {
        return this.shapeParameter;
    }

    public Parameter getPInvParameter() {
        return this.invarParameter;
    }

    public void setMutationRateParameter(Parameter parameter) {
        if (this.muParameter != null) {
            this.removeVariable(this.muParameter);
        }
        this.muParameter = parameter;
        if (this.muParameter != null) {
            this.addVariable(this.muParameter);
        }
    }

    public void setAlphaParameter(Parameter parameter) {
        if (this.shapeParameter != null) {
            this.removeVariable(this.shapeParameter);
        }
        this.shapeParameter = parameter;
        if (this.shapeParameter != null) {
            this.addVariable(this.shapeParameter);
        }
    }

    public void setPInvParameter(Parameter parameter) {
        if (this.invarParameter != null) {
            this.removeVariable(this.invarParameter);
        }
        this.invarParameter = parameter;
        if (this.invarParameter != null) {
            this.addVariable(this.invarParameter);
        }
    }

    @Override
    public boolean integrateAcrossCategories() {
        return true;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public int getCategoryOfSite(int n) {
        throw new IllegalArgumentException("Integrating across categories");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n) {
        GammaSiteModel gammaSiteModel = this;
        synchronized (gammaSiteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        double d = this.muParameter != null ? this.muParameter.getParameterValue(0) : 1.0;
        return this.categoryRates[n] * d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates() {
        GammaSiteModel gammaSiteModel = this;
        synchronized (gammaSiteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        double d = this.muParameter != null ? this.muParameter.getParameterValue(0) : 1.0;
        double[] dArray = new double[this.categoryRates.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.categoryRates[i] * d;
        }
        return dArray;
    }

    public void getTransitionProbabilities(double d, double[] dArray) {
        this.substitutionModel.getTransitionProbabilities(d, dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProportionForCategory(int n) {
        GammaSiteModel gammaSiteModel = this;
        synchronized (gammaSiteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryProportions() {
        GammaSiteModel gammaSiteModel = this;
        synchronized (gammaSiteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions;
    }

    private void calculateCategoryRates() {
        double d = 1.0;
        int n = 0;
        if (this.invarParameter != null) {
            this.categoryRates[0] = 0.0;
            this.categoryProportions[0] = this.invarParameter.getParameterValue(0);
            d = 1.0 - this.categoryProportions[0];
            n = 1;
        }
        if (this.shapeParameter != null) {
            int n2;
            double d2 = this.shapeParameter.getParameterValue(0);
            double d3 = 0.0;
            int n3 = this.categoryCount - n;
            for (n2 = 0; n2 < n3; ++n2) {
                this.categoryRates[n2 + n] = GammaDistribution.quantile((2.0 * (double)n2 + 1.0) / (2.0 * (double)n3), d2, 1.0 / d2);
                d3 += this.categoryRates[n2 + n];
                this.categoryProportions[n2 + n] = d / (double)n3;
            }
            d3 = d * d3 / (double)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = n2 + n;
                this.categoryRates[n4] = this.categoryRates[n4] / d3;
            }
        } else {
            this.categoryRates[n] = 1.0 / d;
            this.categoryProportions[n] = d;
        }
        this.ratesKnown = true;
    }

    @Override
    public FrequencyModel getFrequencyModel() {
        return this.substitutionModel.getFrequencyModel();
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.shapeParameter) {
            this.ratesKnown = false;
        } else if (variable == this.invarParameter) {
            this.ratesKnown = false;
        }
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }
}

